/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.Reference;
import javax.jmi.model.RefersTo;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.mdr.DTDProducer;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.xmi.ElementsCache;
import org.netbeans.lib.jmi.xmi.WriterBase;

public class XmiDtdProducer
extends DTDProducer {
    public static String TAG_ELEMENT = "!ELEMENT";
    public static String TAG_ATTLIST = "!ATTLIST";
    public static String TAG_REQUIRED = "#REQUIRED";
    public static String TAG_PCDATA = "#PCDATA";
    public static String TAG_CDATA = "CDATA";
    public static String TAG_IMPLIED = "#IMPLIED";
    public static String TAG_IDREFS = "IDREFS";
    public static String TAG_EMPTY = "EMPTY";
    public static String TAG_XMI_REFERENCE = "XMI.reference";
    public static String TAG_XMI_EXTENSION = "XMI.extension";
    public static String TAG_XMI_VALUE = "xmi.value";
    public static String TAG_XMI_FIXED_ATTRIBS = "%XMI.element.att; %XMI.link.att;";
    private static String END_OF_LICENCE_MARKER = "<!-- -->";
    private static String FIXED_DTD_FILE = "resources/fixed.dtd";
    private static int LINE_BOUND = 60;
    private PrintStream stream;
    private RefPackage extent;
    private ElementsCache elementsCache;
    private Set trackedPackages;
    private Map classHierarchy;
    private Map allSubtypes_cache;
    private Map namespaces;
    private boolean isFirstItem;
    private int charsCounter;

    public void init() {
        this.elementsCache = new ElementsCache(this.extent);
        this.trackedPackages = new HashSet();
        this.classHierarchy = new HashMap();
        this.allSubtypes_cache = new HashMap();
        this.namespaces = new HashMap();
        this.elementsCache = new ElementsCache(this.extent);
        this.findNamespaces(this.extent);
        this.trackedPackages.clear();
    }

    public void startElement(String name) {
        this.stream.println();
        this.isFirstItem = true;
        this.stream.print("<" + TAG_ELEMENT + " ");
        this.stream.print(name);
        this.charsCounter = TAG_ELEMENT.length() + 2 + name.length();
    }

    public void addEmptyElement() {
        this.stream.println(" " + TAG_EMPTY + ">");
    }

    public void addElementItem(String name) {
        if (!this.isFirstItem) {
            this.stream.print(" | ");
            this.charsCounter += 3;
        } else {
            this.isFirstItem = false;
            this.stream.print(" (");
            this.charsCounter += 2;
        }
        this.charsCounter += name.length();
        if (this.charsCounter > LINE_BOUND) {
            this.stream.println();
            this.stream.print("    ");
            this.charsCounter = 4;
        }
        this.stream.print(name);
    }

    public void endElement() {
        this.stream.println(")* >");
    }

    public void startAttlist(String text) {
        this.stream.print("<" + TAG_ATTLIST + " ");
        this.stream.print(text);
    }

    public void addAttlistItem(String text) {
        this.stream.println();
        this.stream.print("   " + text);
    }

    public void endAttlist() {
        this.stream.println(">");
    }

    public void generate(OutputStream stream, RefPackage extent) {
        this.stream = new PrintStream(stream);
        this.extent = extent;
        this.init();
        this.writeFixedContent();
        this.writeNamespaces();
        this.writePackageDTD(extent);
        try {
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writePackageDTD(RefPackage pkg) {
        if (this.trackedPackages.contains(pkg)) {
            return;
        }
        this.trackedPackages.add(pkg);
        Iterator iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.writePackageDTD((RefPackage)iter.next());
        }
        iter = pkg.refAllClasses().iterator();
        while (iter.hasNext()) {
            this.writeClassDTD((RefClass)iter.next());
        }
        iter = pkg.refAllClasses().iterator();
        while (iter.hasNext()) {
            this.writeStaticAttributesDTD((RefClass)iter.next());
        }
        iter = this.getFreeAssociations(pkg).iterator();
        while (iter.hasNext()) {
            this.writeAssociationDTD((Association)iter.next());
        }
        this.writePackageElementDef(pkg);
    }

    public void writeClassDTD(RefClass proxy) {
        StringBuffer buffer = new StringBuffer();
        MofClass meta = (MofClass)proxy.refMetaObject();
        String className = this.objectName((ModelElement)meta);
        List instAttrs = this.elementsCache.instanceAttributes(meta);
        List references = this.elementsCache.references(meta);
        Iterator iter = instAttrs.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (attr.getContainer() != meta) continue;
            this.writeAttributeElemDef(attr);
        }
        iter = references.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            if (ref.getContainer() != meta) continue;
            this.startElement(this.elementName((ModelElement)ref));
            MofClass type = (MofClass)ref.getType();
            Iterator it = this.elementsCache.getAllSubtypes(type).iterator();
            while (it.hasNext()) {
                this.addElementItem(this.objectName((ModelElement)((MofClass)it.next())));
            }
            this.endElement();
        }
        this.startElement(className);
        Iterator it = instAttrs.iterator();
        while (it.hasNext()) {
            this.addElementItem(this.elementName((ModelElement)((Attribute)it.next())));
        }
        it = references.iterator();
        while (it.hasNext()) {
            this.addElementItem(this.elementName((ModelElement)((Reference)it.next())));
        }
        it = this.getComposites(meta).iterator();
        while (it.hasNext()) {
            this.addElementItem(this.objectName((ModelElement)((MofClass)it.next())));
        }
        this.addElementItem(TAG_XMI_EXTENSION);
        this.endElement();
        buffer.delete(0, buffer.length());
        this.startAttlist(className);
        it = references.iterator();
        while (it.hasNext()) {
            buffer.append(((Reference)it.next()).getName());
            buffer.append(" " + TAG_IDREFS + " " + TAG_IMPLIED);
            this.addAttlistItem(buffer.toString());
            buffer.delete(0, buffer.length());
        }
        it = instAttrs.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            buffer.append(attr.getName());
            Classifier type = this.getType((TypedElement)attr);
            if (type instanceof EnumerationType) {
                int prefixLength = this.labelPrefix((EnumerationType)type).length();
                buffer.append(" (");
                Iterator it_2 = ((EnumerationType)type).getLabels().iterator();
                while (it_2.hasNext()) {
                    buffer.append(((String)it_2.next()).substring(prefixLength));
                    if (!it_2.hasNext()) continue;
                    buffer.append("|");
                }
                buffer.append(") " + TAG_IMPLIED);
            } else if (type instanceof MofClass) {
                buffer.append(" " + TAG_IDREFS + " " + TAG_IMPLIED);
            } else {
                buffer.append(" " + TAG_CDATA + " " + TAG_IMPLIED);
            }
            this.addAttlistItem(buffer.toString());
            buffer.delete(0, buffer.length());
        }
        this.addAttlistItem(TAG_XMI_FIXED_ATTRIBS);
        this.endAttlist();
    }

    public void writeStaticAttributesDTD(RefClass proxy) {
        MofClass meta = (MofClass)proxy.refMetaObject();
        Iterator iter = this.elementsCache.classAttributes(meta).iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (attr.getContainer() != meta) continue;
            this.writeAttributeElemDef(attr);
        }
    }

    public void writeAssociationDTD(Association assoc) {
        HashSet subtypes = new HashSet();
        Iterator iter = assoc.getContents().iterator();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (!(elem instanceof AssociationEnd)) continue;
            subtypes.addAll(this.elementsCache.getAllSubtypes((MofClass)((AssociationEnd)elem).getType()));
        }
        String name = this.objectName((ModelElement)assoc);
        this.startElement(name);
        iter = subtypes.iterator();
        while (iter.hasNext()) {
            this.addElementItem(this.objectName((ModelElement)((MofClass)iter.next())));
        }
        this.addElementItem(TAG_XMI_EXTENSION);
        this.endElement();
        this.startAttlist(name);
        this.addAttlistItem(TAG_XMI_FIXED_ATTRIBS);
        this.endAttlist();
    }

    public void writeAttributeElemDef(Attribute attr) {
        StringBuffer buffer = new StringBuffer();
        Classifier type = this.getType((TypedElement)attr);
        boolean isEnum = type instanceof EnumerationType;
        this.startElement(this.elementName((ModelElement)attr));
        if (isEnum) {
            this.addEmptyElement();
        } else if (type instanceof MofClass) {
            Iterator it = this.elementsCache.getAllSubtypes((MofClass)type).iterator();
            this.addElementItem(this.objectName((ModelElement)((MofClass)it.next())));
            while (it.hasNext()) {
                MofClass clazz = (MofClass)it.next();
                this.addElementItem(this.objectName((ModelElement)clazz));
            }
            this.endElement();
        } else if (type instanceof StructureType) {
            this.addElementItem("XMI.field");
            this.endElement();
        } else {
            this.addElementItem(TAG_PCDATA);
            this.addElementItem(TAG_XMI_REFERENCE);
            this.endElement();
        }
        if (isEnum) {
            int prefixLength = this.labelPrefix((EnumerationType)type).length();
            buffer = new StringBuffer();
            this.startAttlist(this.elementName((ModelElement)attr));
            buffer.append(TAG_XMI_VALUE + " (");
            Iterator it = ((EnumerationType)type).getLabels().iterator();
            while (it.hasNext()) {
                buffer.append(((String)it.next()).substring(prefixLength));
                if (!it.hasNext()) continue;
                buffer.append("|");
            }
            buffer.append(") " + TAG_REQUIRED);
            this.addAttlistItem(buffer.toString());
            this.endAttlist();
        }
    }

    public void writeFixedContent() {
        URL fixedDTD = ((Object)((Object)this)).getClass().getResource(FIXED_DTD_FILE);
        if (fixedDTD == null) {
            throw new DebugException("Resource not found: " + FIXED_DTD_FILE);
        }
        try {
            String line;
            InputStream in = fixedDTD.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while (!(line = reader.readLine()).equals(END_OF_LICENCE_MARKER)) {
            }
            line = reader.readLine();
            while (line != null) {
                this.stream.println(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            Logger.getDefault().log("Unable to open " + FIXED_DTD_FILE + ": " + e.getMessage());
            throw new DebugException(e.getMessage());
        }
    }

    public void writeNamespaces() {
        HashSet names = new HashSet();
        if (this.namespaces.size() > 0) {
            this.startAttlist("XMI");
            Iterator iter = this.namespaces.entrySet().iterator();
            while (iter.hasNext()) {
                Object name = iter.next().getValue();
                if (names.contains(name)) continue;
                this.addAttlistItem("xmlns:" + name + " " + TAG_CDATA + " " + TAG_IMPLIED);
                names.add(name);
            }
            this.endAttlist();
        }
    }

    public void writePackageElementDef(RefPackage pkg) {
        MofPackage meta = (MofPackage)pkg.refMetaObject();
        String packageName = this.packageName(meta);
        HashSet classes = new HashSet();
        StringBuffer buffer = new StringBuffer();
        Iterator iter = pkg.refAllClasses().iterator();
        while (iter.hasNext()) {
            classes.addAll(this.elementsCache.getAllSubtypes((MofClass)((RefClass)iter.next()).refMetaObject()));
        }
        this.startElement(packageName);
        iter = classes.iterator();
        while (iter.hasNext()) {
            this.addElementItem(this.objectName((ModelElement)((MofClass)iter.next())));
        }
        iter = this.getFreeAssociations(pkg).iterator();
        while (iter.hasNext()) {
            this.addElementItem(this.objectName((ModelElement)((Association)iter.next())));
        }
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            RefPackage refPkg = (RefPackage)iter.next();
            MofPackage metaPkg = (MofPackage)refPkg.refMetaObject();
            if (metaPkg.getContainer() != meta) continue;
            this.addElementItem(this.packageName(metaPkg));
        }
        this.addElementItem(TAG_XMI_EXTENSION);
        this.endElement();
        this.startAttlist(packageName);
        this.addAttlistItem(TAG_XMI_FIXED_ATTRIBS);
        this.endAttlist();
    }

    private void findNamespaces(RefPackage pkg) {
        if (this.trackedPackages.contains(pkg)) {
            return;
        }
        this.trackedPackages.add(pkg);
        MofPackage metaPackage = (MofPackage)pkg.refMetaObject();
        String name = WriterBase.getTagValue((ModelElement)metaPackage, "org.omg.xmi.namespace");
        if (name != null) {
            this.namespaces.put(metaPackage, name);
        }
        Iterator iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.findNamespaces((RefPackage)iter.next());
        }
    }

    public String elementName(ModelElement element) {
        Namespace container = element.getContainer();
        return this.objectName((ModelElement)container) + '.' + element.getName();
    }

    public String objectName(ModelElement element) {
        String namespace = (String)this.namespaces.get(element.getContainer());
        if (namespace != null) {
            return namespace + ":" + element.getName();
        }
        return this.qualifiedName(element);
    }

    public String packageName(MofPackage pkg) {
        String namespace = (String)this.namespaces.get(pkg);
        if (namespace != null) {
            return namespace + ":" + pkg.getName();
        }
        return this.qualifiedName((ModelElement)pkg);
    }

    public String qualifiedName(ModelElement element) {
        Iterator iter = element.getQualifiedName().iterator();
        String name = (String)iter.next();
        while (iter.hasNext()) {
            name = name.concat(".").concat((String)iter.next());
        }
        return name;
    }

    public String labelPrefix(EnumerationType type) {
        String prefix = WriterBase.getTagValue((ModelElement)type, "org.omg.xmi.enumerationUnprefix");
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    public Classifier getType(TypedElement elem) {
        Classifier type = elem.getType();
        while (type instanceof AliasType) {
            type = ((AliasType)type).getType();
        }
        return type;
    }

    public Set getComposites(MofClass meta) {
        return new HashSet();
    }

    public Set getFreeAssociations(RefPackage pkg) {
        ModelPackage model = (ModelPackage)pkg.refMetaObject().refImmediatePackage();
        RefersTo refersTo = model.getRefersTo();
        HashSet<Association> set = new HashSet<Association>();
        Iterator iter = pkg.refAllAssociations().iterator();
        while (iter.hasNext()) {
            Association assoc = (Association)((RefAssociation)iter.next()).refMetaObject();
            boolean found = false;
            Iterator it = assoc.getContents().iterator();
            while (it.hasNext()) {
                Collection col;
                Object elem = it.next();
                if (!(elem instanceof AssociationEnd) || (col = refersTo.getReferent((AssociationEnd)elem)) == null || col.size() <= 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            set.add(assoc);
        }
        return set;
    }
}

