/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.abort;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.abort.JobEntryAbort;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

@PluginDialog(id="ABORT", image="ABR.svg", pluginType=PluginDialog.PluginType.JOBENTRY, documentationUrl="http://wiki.pentaho.com/display/EAI/Abort+Job")
public class JobEntryAbortDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryAbortDialog.class;
    private Text wName;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryAbort jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private TextVar wMessageAbort;

    public JobEntryAbortDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryAbort)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobEntryAbortDialog.Jobname.Label", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryAbortDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobEntryAbortDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"JobEntryAbortDialog.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlMessageAbort = new Label((Composite)this.shell, 131072);
        wlMessageAbort.setText(BaseMessages.getString(PKG, (String)"JobEntryAbortDialog.MessageAbort.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMessageAbort);
        FormData fdlMessageAbort = new FormData();
        fdlMessageAbort.left = new FormAttachment(0, 0);
        fdlMessageAbort.right = new FormAttachment(middle, 0);
        fdlMessageAbort.top = new FormAttachment((Control)this.wName, margin);
        wlMessageAbort.setLayoutData((Object)fdlMessageAbort);
        this.wMessageAbort = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wMessageAbort);
        this.wMessageAbort.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryAbortDialog.MessageAbort.Tooltip", (String[])new String[0]));
        this.wMessageAbort.addModifyListener(lsMod);
        FormData fdMessageAbort = new FormData();
        fdMessageAbort.left = new FormAttachment(middle, 0);
        fdMessageAbort.top = new FormAttachment((Control)this.wName, margin);
        fdMessageAbort.right = new FormAttachment(100, 0);
        this.wMessageAbort.setLayoutData((Object)fdMessageAbort);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOK, this.wCancel}, (int)margin, (Control)this.wMessageAbort);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryAbortDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryAbortDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryAbortDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryAbortDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobAbortDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        if (this.jobEntry.getMessageabort() != null) {
            this.wMessageAbort.setText(this.jobEntry.getMessageabort());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setMessageabort(this.wMessageAbort.getText());
        this.dispose();
    }
}

