/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.abort;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.abort.AbortMeta;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

@PluginDialog(id="Abort", image="ABR.svg", pluginType=PluginDialog.PluginType.STEP, documentationUrl="Products/Data_Integration/Transformation_Step_Reference/Abort")
public class AbortDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = AbortDialog.class;
    private Label wlRowThreshold;
    private TextVar wRowThreshold;
    private FormData fdlRowThreshold;
    private FormData fdRowThreshold;
    private Label wlMessage;
    private TextVar wMessage;
    private FormData fdlMessage;
    private FormData fdMessage;
    private Button wAlwaysLogRows;
    private FormData fdAlwaysLogRows;
    private AbortMeta input;
    private ModifyListener lsMod;
    private SelectionAdapter lsSelMod;
    private Group wLoggingGroup;
    private Button wAbortButton;
    private Button wAbortWithErrorButton;
    private Button wSafeStopButton;
    private Group wOptionsGroup;
    private Label hSpacer;

    public AbortDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (AbortMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setMinimumSize(400, 520);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        this.lsMod = e -> this.input.setChanged();
        this.lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AbortDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Shell.Title", (String[])new String[0]));
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 150;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.fdStepname.width = 250;
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        fdlicon.bottom = new FormAttachment((Control)spacer, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        this.hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.height = 2;
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        this.hSpacer.setLayoutData((Object)fdhSpacer);
        this.buildOptions((Control)spacer);
        this.buildLogging((Composite)this.wOptionsGroup);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                AbortDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                AbortDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbortDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wRowThreshold.addSelectionListener(this.lsDef);
        this.wMessage.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AbortDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void buildOptions(Control widgetAbove) {
        this.wOptionsGroup = new Group((Composite)this.shell, 16);
        this.props.setLook((Control)this.wOptionsGroup);
        this.wOptionsGroup.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.Group.Label", (String[])new String[0]));
        FormLayout flOptionsGroup = new FormLayout();
        flOptionsGroup.marginHeight = 15;
        flOptionsGroup.marginWidth = 15;
        this.wOptionsGroup.setLayout((Layout)flOptionsGroup);
        FormData fdOptionsGroup = new FormData();
        fdOptionsGroup.left = new FormAttachment(0, 0);
        fdOptionsGroup.top = new FormAttachment(widgetAbove, 15);
        fdOptionsGroup.right = new FormAttachment(100, 0);
        this.wOptionsGroup.setLayoutData((Object)fdOptionsGroup);
        this.wAbortButton = new Button((Composite)this.wOptionsGroup, 16);
        this.wAbortButton.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wAbortButton.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.Abort.Label", (String[])new String[0]));
        FormData fdAbort = new FormData();
        fdAbort.left = new FormAttachment(0, 0);
        fdAbort.top = new FormAttachment(0, 0);
        this.wAbortButton.setLayoutData((Object)fdAbort);
        this.props.setLook((Control)this.wAbortButton);
        this.wAbortWithErrorButton = new Button((Composite)this.wOptionsGroup, 16);
        this.wAbortWithErrorButton.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wAbortWithErrorButton.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.AbortWithError.Label", (String[])new String[0]));
        FormData fdAbortWithError = new FormData();
        fdAbortWithError.left = new FormAttachment(0, 0);
        fdAbortWithError.top = new FormAttachment((Control)this.wAbortButton, 10);
        this.wAbortWithErrorButton.setLayoutData((Object)fdAbortWithError);
        this.props.setLook((Control)this.wAbortWithErrorButton);
        this.wSafeStopButton = new Button((Composite)this.wOptionsGroup, 16);
        this.wSafeStopButton.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wSafeStopButton.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.SafeStop.Label", (String[])new String[0]));
        FormData fdSafeStop = new FormData();
        fdSafeStop.left = new FormAttachment(0, 0);
        fdSafeStop.top = new FormAttachment((Control)this.wAbortWithErrorButton, 10);
        this.wSafeStopButton.setLayoutData((Object)fdSafeStop);
        this.props.setLook((Control)this.wSafeStopButton);
        this.wlRowThreshold = new Label((Composite)this.wOptionsGroup, 131072);
        this.wlRowThreshold.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.RowThreshold.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRowThreshold);
        this.fdlRowThreshold = new FormData();
        this.fdlRowThreshold.left = new FormAttachment(0, 0);
        this.fdlRowThreshold.top = new FormAttachment((Control)this.wSafeStopButton, 10);
        this.wlRowThreshold.setLayoutData((Object)this.fdlRowThreshold);
        this.wRowThreshold = new TextVar((VariableSpace)this.transMeta, (Composite)this.wOptionsGroup, 18436);
        this.wRowThreshold.setText("");
        this.props.setLook((Control)this.wRowThreshold);
        this.wRowThreshold.addModifyListener(this.lsMod);
        this.wRowThreshold.setToolTipText(BaseMessages.getString(PKG, (String)"AbortDialog.Options.RowThreshold.Tooltip", (String[])new String[0]));
        this.fdRowThreshold = new FormData();
        this.fdRowThreshold.left = new FormAttachment(0, 0);
        this.fdRowThreshold.top = new FormAttachment((Control)this.wlRowThreshold, 5);
        this.fdRowThreshold.width = 174;
        this.wRowThreshold.setLayoutData((Object)this.fdRowThreshold);
    }

    private void buildLogging(Composite widgetAbove) {
        this.wLoggingGroup = new Group((Composite)this.shell, 16);
        this.props.setLook((Control)this.wLoggingGroup);
        this.wLoggingGroup.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.Group", (String[])new String[0]));
        FormLayout flLoggingGroup = new FormLayout();
        flLoggingGroup.marginHeight = 15;
        flLoggingGroup.marginWidth = 15;
        this.wLoggingGroup.setLayout((Layout)flLoggingGroup);
        FormData fdLoggingGroup = new FormData();
        fdLoggingGroup.left = new FormAttachment(0, 0);
        fdLoggingGroup.top = new FormAttachment((Control)widgetAbove, 15);
        fdLoggingGroup.right = new FormAttachment(100, 0);
        fdLoggingGroup.bottom = new FormAttachment((Control)this.hSpacer, -15);
        this.wLoggingGroup.setLayoutData((Object)fdLoggingGroup);
        this.wlMessage = new Label((Composite)this.wLoggingGroup, 131072);
        this.wlMessage.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.AbortMessage.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMessage);
        this.fdlMessage = new FormData();
        this.fdlMessage.left = new FormAttachment(0, 0);
        this.fdlMessage.top = new FormAttachment(0, 0);
        this.wlMessage.setLayoutData((Object)this.fdlMessage);
        this.wMessage = new TextVar((VariableSpace)this.transMeta, (Composite)this.wLoggingGroup, 18436);
        this.wMessage.setText("");
        this.props.setLook((Control)this.wMessage);
        this.wMessage.addModifyListener(this.lsMod);
        this.wMessage.setToolTipText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.AbortMessage.Tooltip", (String[])new String[0]));
        this.fdMessage = new FormData();
        this.fdMessage.left = new FormAttachment(0, 0);
        this.fdMessage.top = new FormAttachment((Control)this.wlMessage, 5);
        this.fdMessage.right = new FormAttachment(100, 0);
        this.wMessage.setLayoutData((Object)this.fdMessage);
        this.wAlwaysLogRows = new Button((Composite)this.wLoggingGroup, 32);
        this.wAlwaysLogRows.setText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.AlwaysLogRows.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wAlwaysLogRows);
        this.wAlwaysLogRows.setToolTipText(BaseMessages.getString(PKG, (String)"AbortDialog.Logging.AlwaysLogRows.Tooltip", (String[])new String[0]));
        this.fdAlwaysLogRows = new FormData();
        this.fdAlwaysLogRows.left = new FormAttachment(0, 0);
        this.fdAlwaysLogRows.top = new FormAttachment((Control)this.wMessage, 10);
        this.wAlwaysLogRows.setLayoutData((Object)this.fdAlwaysLogRows);
        this.wAlwaysLogRows.addSelectionListener((SelectionListener)this.lsSelMod);
    }

    private Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ABR.svg", (int)48, (int)48);
    }

    public void getData() {
        if (this.input.getRowThreshold() != null) {
            this.wRowThreshold.setText(this.input.getRowThreshold());
        }
        if (this.input.getMessage() != null) {
            this.wMessage.setText(this.input.getMessage());
        }
        this.wAlwaysLogRows.setSelection(this.input.isAlwaysLogRows());
        this.wAbortButton.setSelection(this.input.isAbort());
        this.wAbortWithErrorButton.setSelection(this.input.isAbortWithError());
        this.wSafeStopButton.setSelection(this.input.isSafeStop());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void getInfo(AbortMeta in) {
        this.input.setRowThreshold(this.wRowThreshold.getText());
        this.input.setMessage(this.wMessage.getText());
        this.input.setAlwaysLogRows(this.wAlwaysLogRows.getSelection());
        AbortMeta.AbortOption abortOption = AbortMeta.AbortOption.ABORT;
        if (this.wAbortWithErrorButton.getSelection()) {
            abortOption = AbortMeta.AbortOption.ABORT_WITH_ERROR;
        } else if (this.wSafeStopButton.getSelection()) {
            abortOption = AbortMeta.AbortOption.SAFE_STOP;
        }
        this.input.setAbortOption(abortOption);
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.stepname = this.wStepname.getText();
        this.dispose();
    }
}

