/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jpivot;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.actions.ActionFactory;
import org.pentaho.jpivot.JsonBuilder;
import org.pentaho.jpivot.PivotViewAction;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.engine.PentahoSystemException;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.SoapHelper;
import org.pentaho.platform.engine.services.WebServiceUtil;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCube;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.platform.web.http.HttpOutputHandler;
import org.pentaho.platform.web.http.api.resources.XactionUtil;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.xml.sax.EntityResolver;

public class AnalysisViewService
extends ServletBase {
    public static final String jpivotPluginDir;
    public static String ANALYSIS_VIEW_TEMPLATE;
    private static final long serialVersionUID = 831738225052159697L;
    private static final Log logger;
    private final IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)PentahoSessionHolder.getSession());

    public Log getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String responseEncoding = PentahoSystem.getSystemSetting((String)"web-service-encoding", (String)"utf-8");
        String component = request.getParameter("component");
        if (component.equalsIgnoreCase("newView")) {
            this.newAnalysisView(request, response);
            return;
        }
        PentahoSystem.systemEntryPoint();
        try {
            boolean wrapWithSoap = "false".equals(request.getParameter("ajax"));
            String actionPath = request.getParameter("path");
            String content = null;
            try {
                content = this.getPayloadAsString(request);
            }
            catch (IOException ioEx) {
                String msg = Messages.getInstance().getErrorString("AdhocWebService.ERROR_0006_FAILED_TO_GET_PAYLOAD_FROM_REQUEST");
                this.error(msg, ioEx);
                XmlDom4JHelper.saveDom((Document)WebServiceUtil.createErrorDocument((String)(msg + " " + ioEx.getLocalizedMessage())), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
            }
            HttpRequestParameterProvider parameterProvider = null;
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (!StringUtils.isEmpty((String)content)) {
                Document doc = null;
                try {
                    doc = XmlDom4JHelper.getDocFromString((String)content, (EntityResolver)new PentahoEntityResolver());
                }
                catch (XmlParseException e) {
                    String msg = Messages.getInstance().getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
                    this.error(msg, e);
                    XmlDom4JHelper.saveDom((Document)WebServiceUtil.createErrorDocument((String)msg), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
                }
                List parameterNodes = doc.selectNodes("//SOAP-ENV:Body/*/*");
                for (int i = 0; i < parameterNodes.size(); ++i) {
                    Node parameterNode = (Node)parameterNodes.get(i);
                    String parameterName = parameterNode.getName();
                    String parameterValue = parameterNode.getText();
                    if ("action".equals(parameterName)) {
                        parameters.put("path", parameterValue);
                        continue;
                    }
                    if ("component".equals(parameterName)) {
                        component = parameterValue;
                        continue;
                    }
                    parameters.put(parameterName, parameterValue);
                }
                parameterProvider = new SimpleParameterProvider(parameters);
            } else {
                parameterProvider = new HttpRequestParameterProvider(request);
            }
            IPentahoSession userSession = this.getPentahoSession(request);
            this.dispatch(request, response, component, (IParameterProvider)parameterProvider, userSession, wrapWithSoap);
        }
        catch (IOException ioEx) {
            String msg = Messages.getInstance().getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
            this.error(msg, ioEx);
            XmlDom4JHelper.saveDom((Document)WebServiceUtil.createErrorDocument((String)msg), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
        }
        catch (PentahoSystemException ex) {
            String msg = ex.getLocalizedMessage();
            this.error(msg, ex);
            XmlDom4JHelper.saveDom((Document)WebServiceUtil.createErrorDocument((String)msg), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
        }
        catch (PentahoAccessControlException ex) {
            String msg = ex.getLocalizedMessage();
            this.error(msg, ex);
            XmlDom4JHelper.saveDom((Document)WebServiceUtil.createErrorDocument((String)msg), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected void dispatch(HttpServletRequest request, HttpServletResponse response, String component, IParameterProvider parameterProvider, IPentahoSession userSession, boolean wrapWithSoap) throws IOException, PentahoSystemException, PentahoAccessControlException {
        if ("createNewView".equals(component)) {
            this.createNewView(userSession, parameterProvider, request, response, wrapWithSoap);
        } else if ("listCatalogs".equals(component)) {
            this.listCatalogs(userSession, (OutputStream)response.getOutputStream(), wrapWithSoap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newAnalysisView(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PentahoSystem.systemEntryPoint();
        try {
            List catalogs = this.mondrianCatalogService.listCatalogs(this.getPentahoSession(request), true);
            String newAnalysisViewTemplate = "system" + File.separator + jpivotPluginDir + File.separator + "resources" + File.separator + "new_analysis_view.html";
            String file = PentahoSystem.getApplicationContext().getSolutionPath(newAnalysisViewTemplate);
            String content = FileUtils.readFileToString((File)new File(file), (String)LocaleHelper.getSystemEncoding());
            content = content.replaceAll("\\{context\\}", request.getContextPath());
            String json = new JsonBuilder().generateJsonForResponse(catalogs);
            content = content.replaceAll("\\{json\\}", json);
            response.getWriter().print(content);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    public void listCatalogs(IPentahoSession userSession, OutputStream outputStream, boolean wrapWithSoap) throws IOException {
        StringBuilder builder = new StringBuilder();
        List catalogs = this.mondrianCatalogService.listCatalogs(userSession, true);
        DefaultElement rootElement = new DefaultElement("catalogs");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        for (MondrianCatalog catalog : catalogs) {
            Element catalogElement = rootElement.addElement("catalog").addAttribute("name", catalog.getName());
            Element schemaElement = catalogElement.addElement("schema").addAttribute("name", catalog.getSchema().getName());
            Element cubesElement = schemaElement.addElement("cubes");
            for (MondrianCube cube : catalog.getSchema().getCubes()) {
                cubesElement.addElement("cube").addAttribute("name", cube.getName());
            }
        }
        if (wrapWithSoap) {
            XmlDom4JHelper.saveDom((Document)SoapHelper.createSoapResponseDocument((Document)doc), (OutputStream)outputStream, (String)PentahoSystem.getSystemSetting((String)"web-service-encoding", (String)"utf-8"), (boolean)true);
        } else {
            XmlDom4JHelper.saveDom((Document)doc, (OutputStream)outputStream, (String)PentahoSystem.getSystemSetting((String)"web-service-encoding", (String)"utf-8"), (boolean)true);
        }
    }

    public void createNewView(IPentahoSession session, IParameterProvider parameterProvider, HttpServletRequest request, HttpServletResponse response, boolean wrapWithSoap) throws IOException, PentahoSystemException, PentahoAccessControlException {
        try {
            String solutionName = parameterProvider.getStringParameter("solution", null);
            String solutionPath = parameterProvider.getStringParameter("actionPath", null);
            String model = parameterProvider.getStringParameter("schema", null);
            String cube = parameterProvider.getStringParameter("cube", null);
            String title = parameterProvider.getStringParameter("name", null);
            String description = parameterProvider.getStringParameter("descr", null);
            String jndi = null;
            String jdbc = null;
            String xactionFilename = parameterProvider.getStringParameter("actionName", null);
            MondrianCatalog selectedCatalog = this.mondrianCatalogService.getCatalog(model, session);
            if (selectedCatalog == null) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0004_MODEL_NULL"));
            }
            if (selectedCatalog.isJndi()) {
                try {
                    IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
                    jndi = datasourceService.getDSUnboundName(selectedCatalog.getJndi());
                }
                catch (ObjectFactoryException objface) {
                    Logger.error((String)"AnalysisViewService", (String)Messages.getInstance().getErrorString("AnalysisViewService.ERROR_0001_UNABLE_TO_FACTORY_OBJECT", new Object[]{jndi}), (Throwable)objface);
                }
            } else {
                jdbc = null;
            }
            model = selectedCatalog.getDefinition();
            if (solutionName == null || solutionName.equals("")) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0001_SOLUTION_NAME_NULL"));
            }
            if (solutionPath == null || solutionPath.equals("")) {
                solutionPath = "/";
            }
            if (title == null || title.equals("")) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0003_TITLE_NULL"));
            }
            if (model == null || model.equals("")) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0004_MODEL_NULL"));
            }
            if (description == null || description.equals("")) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0005_DESCRIPTION_NULL"));
            }
            if (jndi == null || jndi.equals("")) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0006_JNDI_NULL"));
            }
            if (cube == null || cube.equals("")) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0007_CUBE_NULL"));
            }
            if (xactionFilename == null || xactionFilename.equals("")) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0008_XACTION_NULL"));
            }
            String path = solutionName;
            if (!solutionName.endsWith("/") && !solutionPath.startsWith("/")) {
                path = path + "/";
            }
            if (!xactionFilename.endsWith(".xjpivot")) {
                xactionFilename = xactionFilename + ".xjpivot";
            }
            path = path + solutionPath;
            boolean overwrite = parameterProvider.getStringParameter("overwrite", "false").equalsIgnoreCase("true");
            String xaction = this.generateXAction(session, title, description, model, jndi, jdbc, cube);
            String processId = "PivotView";
            String instanceId = request.getParameter("instance-id");
            boolean doMessages = "true".equalsIgnoreCase(request.getParameter("debug"));
            HttpOutputHandler outputHandler = XactionUtil.createOutputHandler((HttpServletResponse)response, (OutputStream)XactionUtil.getOutputStream((HttpServletResponse)response, (boolean)false));
            ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class);
            solutionEngine.init(PentahoSessionHolder.getSession());
            IRuntimeContext context = null;
            ArrayList messages = new ArrayList();
            HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
            HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(PentahoSessionHolder.getSession());
            HashMap<String, Object> parameterProviders = new HashMap<String, Object>();
            requestParameters.setParameter("mode", "redirect");
            parameterProviders.put("request", requestParameters);
            parameterProviders.put("session", sessionParameters);
            SimpleUrlFactory urlFactory = new SimpleUrlFactory("");
            context = solutionEngine.execute(xaction, xactionFilename, Messages.getInstance().getString("BaseTest.DEBUG_JUNIT_TEST"), false, true, instanceId, false, parameterProviders, (IOutputHandler)outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
        }
        catch (Exception e) {
            e.printStackTrace(response.getWriter());
        }
    }

    public String generateXAction(IPentahoSession session, String title, String description, String model, String jndi, String jdbc, String cube) throws PentahoSystemException {
        if (ActionFactory.getActionDefinition((String)"PivotViewAction") == null) {
            ActionFactory.pluginActions.put("PivotViewAction", PivotViewAction.class);
        }
        ActionSequenceDocument doc = this.loadAnalysisViewTemplate(session);
        doc.setTitle(title);
        if (session.getName() != null) {
            doc.setAuthor(session.getName());
        } else {
            doc.setAuthor("Analysis View");
        }
        doc.setDescription(description);
        PivotViewAction action = (PivotViewAction)doc.getElement("/action-sequence/actions/action-definition[component-name='PivotViewComponent']");
        action.setModel((IActionInputSource)new ActionInputConstant(model, null));
        if (jndi == null) {
            throw new PentahoSystemException(Messages.getInstance().getErrorString("AnalysisViewService.ERROR_0006_JNDI_NULL"));
        }
        action.setJndi((IActionInputSource)new ActionInputConstant(jndi, null));
        if (cube != null) {
            action.setComponentDefinition("cube", cube);
        }
        return doc.toString();
    }

    public ActionSequenceDocument loadAnalysisViewTemplate(IPentahoSession session) throws PentahoSystemException {
        String analysisViewTemplate = "system" + File.separator + jpivotPluginDir + File.separator + "resources" + File.separator + ANALYSIS_VIEW_TEMPLATE;
        InputStream is = null;
        try {
            File f = new File(PentahoSystem.getApplicationContext().getSolutionPath(analysisViewTemplate));
            if (f.exists()) {
                is = new FileInputStream(f);
                SAXReader reader = new SAXReader();
                Document doc = reader.read(is);
                ActionSequenceDocument actionSequenceDocument = new ActionSequenceDocument(doc);
                return actionSequenceDocument;
            }
            try {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0009_TEMPLATE_DOES_NOT_EXIST", new Object[]{analysisViewTemplate}));
            }
            catch (Exception e) {
                throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0010_TEMPLATE_DOES_NOT_PARSE", new Object[]{analysisViewTemplate}), (Throwable)e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getPayloadAsString(HttpServletRequest request) throws IOException {
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String content = null;
        byte[] buffer = new byte[2048];
        int b = is.read(buffer);
        while (b > 0) {
            os.write(buffer, 0, b);
            b = is.read(buffer);
        }
        content = os.toString(LocaleHelper.getSystemEncoding());
        return content;
    }

    private void sendXActionError(String errorString, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("errorMessage", (Object)errorString);
        response.getWriter().println(errorString);
    }

    public IRuntimeContext getNewAnalysisViewRuntime(HttpServletRequest request, IPentahoSession userSession) throws PentahoSystemException {
        String model;
        String schema = request.getParameter("schema");
        String cube = request.getParameter("cube");
        String instanceId = request.getParameter("instance-id");
        String jndi = null;
        String jdbc = null;
        IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)userSession);
        MondrianCatalog selectedCatalog = mondrianCatalogService.getCatalog(schema, userSession);
        if (selectedCatalog == null) {
            throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0004_MODEL_NULL"));
        }
        if (selectedCatalog.isJndi()) {
            try {
                IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
                jndi = datasourceService.getDSUnboundName(selectedCatalog.getJndi());
            }
            catch (ObjectFactoryException objface) {
                Logger.error((String)"AnalysisViewService", (String)Messages.getInstance().getErrorString("AnalysisViewService.ERROR_0001_UNABLE_TO_FACTORY_OBJECT", new Object[]{jndi}), (Throwable)objface);
            }
        } else {
            jdbc = null;
        }
        if ((model = selectedCatalog.getDefinition()) == null || model.equals("")) {
            throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0004_MODEL_NULL"));
        }
        if (jndi == null || jndi.equals("")) {
            throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0006_JNDI_NULL"));
        }
        if (cube == null || cube.equals("")) {
            throw new PentahoSystemException(Messages.getInstance().getString("AnalysisViewService.ERROR_0007_CUBE_NULL"));
        }
        String xaction = new AnalysisViewService().generateXAction(userSession, Messages.getInstance().getString("BaseTest.DEFAULT_TITLE"), Messages.getInstance().getString("BaseTest.DEFAULT_DESCRIPTION"), model, jndi, jdbc, cube);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SimpleOutputHandler outputHandler = new SimpleOutputHandler((OutputStream)outputStream, true);
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)userSession);
        solutionEngine.init(userSession);
        IRuntimeContext context = null;
        ArrayList messages = new ArrayList();
        HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
        HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
        HashMap<String, Object> parameterProviders = new HashMap<String, Object>();
        requestParameters.setParameter("mode", "execute");
        parameterProviders.put("request", requestParameters);
        parameterProviders.put("session", sessionParameters);
        SimpleUrlFactory urlFactory = new SimpleUrlFactory("");
        context = solutionEngine.execute(xaction, "default.xjpivot", Messages.getInstance().getString("BaseTest.DEBUG_JUNIT_TEST"), false, true, instanceId, false, parameterProviders, (IOutputHandler)outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
        if (context != null && context.getStatus() == 6) {
            return context;
        }
        return null;
    }

    static {
        File f = new File(PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + "pentaho-jpivot-plugin"));
        jpivotPluginDir = f.exists() ? "pentaho-jpivot-plugin" : "pentaho-jpivot-plugin-legacy";
        ANALYSIS_VIEW_TEMPLATE = "analysis_view_template.xjpivot";
        logger = LogFactory.getLog(AnalysisViewService.class);
    }
}

