/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jpivot;

import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringEscapeUtils;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCube;

class JsonBuilder {
    JsonBuilder() {
    }

    String generateJsonForResponse(List<MondrianCatalog> catalogs) {
        StringBuilder builder = new StringBuilder(128);
        builder.append('[');
        int count = 0;
        for (MondrianCatalog catalog : catalogs) {
            if (count != 0) {
                builder.append(',');
            }
            builder.append("{\"schema\":\"").append(StringEscapeUtils.escapeJavaScript((String)catalog.getSchema().getName())).append("\",\"cubes\":[");
            int ccount = 0;
            for (MondrianCube cube : catalog.getSchema().getCubes()) {
                if (ccount != 0) {
                    builder.append(',');
                }
                builder.append('{').append("\"id\":\"").append(StringEscapeUtils.escapeJavaScript((String)cube.getId())).append('\"').append(',').append("\"name\":\"").append(StringEscapeUtils.escapeJavaScript((String)cube.getName())).append('\"').append('}');
                ++ccount;
            }
            builder.append("]}");
            ++count;
        }
        builder.append(']');
        return Matcher.quoteReplacement(builder.toString());
    }
}

