/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.cache.ui;

import com.google.common.collect.ImmutableList;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCache;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCacheFactory;
import org.pentaho.di.trans.dataservice.ui.BindingConverters;
import org.pentaho.di.trans.dataservice.ui.controller.AbstractController;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulTab;
import org.pentaho.ui.xul.components.XulTextbox;

public class ServiceCacheController
extends AbstractController {
    private static final String NAME = "serviceCacheCtrl";
    private final ServiceCacheFactory factory;

    public ServiceCacheController(ServiceCacheFactory factory) {
        this.factory = factory;
        this.setName(NAME);
    }

    public void initBindings(DataServiceModel model) {
        PushDownOptimizationMeta meta = this.locateServiceCacheMeta(model);
        ServiceCache serviceCache = (ServiceCache)meta.getType();
        BindingFactory bindingFactory = this.getBindingFactory();
        XulRadio normalModeRadio = (XulRadio)this.getElementById("regular-type-radio");
        XulRadio streamingRadioButton = (XulRadio)this.getElementById("streaming-type-radio");
        XulTab serviceCacheTab = (XulTab)this.getElementById("service-cache-tab");
        XulCheckbox serviceCacheCheckBox = (XulCheckbox)this.getElementById("service-cache-checkbox");
        XulTextbox serviceCacheTextBox = (XulTextbox)this.getElementById("service-cache-ttl");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        serviceCacheCheckBox.setChecked(meta.isEnabled());
        serviceCacheTab.setVisible(!model.isStreaming());
        try {
            serviceCacheTextBox.setValue(serviceCache.getConfiguredTimeToLive());
        }
        catch (Exception e) {
            this.getLogChannel().logError("Unable to set default TTL", (Throwable)e);
        }
        bindingFactory.createBinding((Object)serviceCacheTextBox, "value", (Object)serviceCache, "timeToLive", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)serviceCacheCheckBox, "checked", (Object)meta, "enabled", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)serviceCacheCheckBox, "checked", (Object)serviceCacheTextBox, "disabled", new BindingConvertor[]{BindingConverters.not()});
        bindingFactory.createBinding((Object)normalModeRadio, "selected", (Object)serviceCacheTab, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)streamingRadioButton, "!selected", (Object)serviceCacheTab, "visible", new BindingConvertor[0]);
    }

    protected PushDownOptimizationMeta locateServiceCacheMeta(DataServiceModel model) {
        PushDownOptimizationMeta meta;
        ImmutableList<PushDownOptimizationMeta> cacheOptimizations = model.getPushDownOptimizations(this.factory.getType());
        if (cacheOptimizations.isEmpty()) {
            meta = new PushDownOptimizationMeta();
            meta.setStepName(model.getServiceStep());
            meta.setType(this.factory.createPushDown());
            model.add(meta);
        } else {
            meta = (PushDownOptimizationMeta)cacheOptimizations.get(0);
        }
        if (cacheOptimizations.size() > 1) {
            model.removeAll(cacheOptimizations.subList(1, cacheOptimizations.size()));
        }
        return meta;
    }
}

