/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.mongod;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationException;
import org.pentaho.di.trans.dataservice.optimization.ValueMetaResolver;
import org.pentaho.di.trans.dataservice.optimization.mongod.MongoFunc;
import org.pentaho.di.trans.dataservice.optimization.mongod.MongoOp;

public class MongodbPredicate {
    private static final String MATCH = "$match";
    private final ValueMetaResolver valueMetaResolver;
    private Condition condition;
    private Map<String, String> fieldMappings;

    public MongodbPredicate(Condition condition, ValueMetaResolver resolver, Map<String, String> fieldMappings) {
        this.valueMetaResolver = resolver;
        this.condition = condition;
        this.fieldMappings = fieldMappings;
    }

    public String asMatch() throws PushDownOptimizationException {
        return QueryBuilder.start((String)MATCH).is((Object)this.conditionAsDBObject()).get().toString();
    }

    public String asFilterCriteria() throws PushDownOptimizationException {
        return this.conditionAsDBObject().toString();
    }

    protected DBObject conditionAsDBObject() throws PushDownOptimizationException {
        return this.buildMongoCondition(this.condition, QueryBuilder.start()).get();
    }

    private QueryBuilder buildMongoCondition(Condition condition, QueryBuilder queryBuilder) throws PushDownOptimizationException {
        return (condition = this.unwrap(condition)).isAtomic() ? this.applyAtomicCondition(condition, queryBuilder) : this.applyCompoundCondition(condition, queryBuilder);
    }

    private QueryBuilder applyAtomicCondition(Condition condition, QueryBuilder queryBuilder) throws PushDownOptimizationException {
        MongoFunc func = MongoFunc.getMongoFunc(condition.getFunction());
        String fieldName = this.getResolvedFieldName(condition.getLeftValuename());
        Object value = this.getResolvedValue(condition);
        if (condition.isNegated()) {
            func.negate(queryBuilder, fieldName, value);
        } else {
            func.affirm(queryBuilder, fieldName, value);
        }
        return queryBuilder;
    }

    private String getResolvedFieldName(String fieldName) {
        String resolvedFieldName = this.fieldMappings.get(fieldName);
        if (resolvedFieldName != null) {
            return resolvedFieldName;
        }
        return fieldName;
    }

    private Object getResolvedValue(Condition condition) throws PushDownOptimizationException {
        ValueMetaAndData rightExact = condition.getRightExact();
        Object value = rightExact.getValueData();
        int type = rightExact.getValueMeta().getType();
        String fieldName = condition.getLeftValuename();
        if (condition.getFunction() == 9) {
            return this.valueMetaResolver.inListToTypedObjectArray(fieldName, (String)value);
        }
        return this.valueMetaResolver.getTypedValue(fieldName, type, value);
    }

    private QueryBuilder applyCompoundCondition(Condition condition, QueryBuilder queryBuilder) throws PushDownOptimizationException {
        this.getMongoOp(condition).apply(queryBuilder, this.conditionListToDBObjectArray(condition.getChildren()));
        return queryBuilder;
    }

    private MongoOp getMongoOp(Condition condition) throws PushDownOptimizationException {
        this.validateConditionForOpDetermination(condition);
        Condition firstChild = (Condition)condition.getChildren().get(1);
        MongoOp op = MongoOp.getMongoOp(firstChild.getOperator());
        if (op == null) {
            throw new PushDownOptimizationException("Unsupported operator:  " + firstChild.getOperatorDesc());
        }
        return op;
    }

    private void validateConditionForOpDetermination(Condition condition) throws PushDownOptimizationException {
        if (condition.getChildren().size() <= 1) {
            throw new PushDownOptimizationException("At least 2 children are required to determine connecting operator.");
        }
        if (condition.isNegated()) {
            throw new PushDownOptimizationException("Negated non-atomic conditions can't be converted to BSON");
        }
    }

    private DBObject[] conditionListToDBObjectArray(List<Condition> conditions) throws PushDownOptimizationException {
        BasicDBList basicDbList = new BasicDBList();
        for (Condition condition : conditions) {
            QueryBuilder childContainer = QueryBuilder.start();
            this.buildMongoCondition(condition, childContainer);
            basicDbList.add((Object)childContainer.get());
        }
        return (DBObject[])basicDbList.toArray((Object[])new DBObject[basicDbList.size()]);
    }

    private Condition unwrap(Condition condition) {
        return condition.getChildren().size() == 1 && !condition.isNegated() ? this.unwrap((Condition)condition.getChildren().get(0)) : condition;
    }
}

