/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen;

import com.google.common.base.Predicate;
import com.google.common.collect.ForwardingSetMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.metaverse.api.StepFieldOperations;

public class SourceLineageMap
extends ForwardingSetMultimap<String, List<StepFieldOperations>> {
    private SetMultimap<String, List<StepFieldOperations>> storage;

    protected SourceLineageMap(SetMultimap<String, List<StepFieldOperations>> storage) {
        this.storage = storage;
    }

    public static SourceLineageMap create() {
        return new SourceLineageMap((SetMultimap<String, List<StepFieldOperations>>)HashMultimap.create());
    }

    public static SourceLineageMap create(Map<String, Set<List<StepFieldOperations>>> operationPaths) {
        SourceLineageMap sourceLineageMap = SourceLineageMap.create();
        for (List lineage : Iterables.concat(operationPaths.values())) {
            if (lineage == null || lineage.isEmpty()) continue;
            String inputStep = ((StepFieldOperations)lineage.get(0)).getStepName();
            sourceLineageMap.put(inputStep, lineage);
        }
        return sourceLineageMap;
    }

    protected SetMultimap<String, List<StepFieldOperations>> delegate() {
        return this.storage;
    }

    public SourceLineageMap filter(Predicate<? super Map.Entry<String, List<StepFieldOperations>>> predicate) {
        return new SourceLineageMap((SetMultimap<String, List<StepFieldOperations>>)Multimaps.filterEntries(this.storage, predicate));
    }

    public SourceLineageMap filterKeys(Predicate<String> predicate) {
        return new SourceLineageMap((SetMultimap<String, List<StepFieldOperations>>)Multimaps.filterKeys(this.storage, predicate));
    }
}

