/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public abstract class AbstractModel
extends XulEventSourceAdapter {
    public abstract Map<String, Object> snapshot();

    public void setChangeSupport(PropertyChangeSupport changeSupport) {
        this.changeSupport = changeSupport;
    }

    protected void firePropertyChanges(Map<String, Object> previous) {
        ImmutableMap<String, Object> update = AbstractModel.buildSnapshot(this.snapshot());
        for (String attr : Sets.union(update.keySet(), previous.keySet())) {
            this.firePropertyChange(attr, previous.get(attr), update.get(attr));
        }
    }

    private static ImmutableMap<String, Object> buildSnapshot(Map<String, Object> snapshot) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : snapshot.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            builder.put(entry);
        }
        return builder.build();
    }

    protected void modify(Runnable runnable) {
        ImmutableMap<String, Object> previous = AbstractModel.buildSnapshot(this.snapshot());
        runnable.run();
        this.firePropertyChanges((Map<String, Object>)previous);
    }
}

