/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import pt.webdetails.cgg.Chart;
import pt.webdetails.cgg.ScriptCreationException;
import pt.webdetails.cgg.ScriptExecuteException;
import pt.webdetails.cgg.datasources.DataSourceFactory;
import pt.webdetails.cgg.datasources.DefaultDataSourceFactory;
import pt.webdetails.cgg.output.DefaultOutputFactory;
import pt.webdetails.cgg.output.OutputFactory;
import pt.webdetails.cgg.scripts.DefaultScriptFactory;
import pt.webdetails.cgg.scripts.Script;
import pt.webdetails.cgg.scripts.ScriptFactory;

public abstract class AbstractCgg {
    private ScriptFactory scriptFactory = new DefaultScriptFactory();
    private OutputFactory outputFactory = DefaultOutputFactory.getInstance();
    private DataSourceFactory dataSourceFactory = DefaultDataSourceFactory.getInstance();

    public synchronized void draw(String scriptFile, String scriptType, String outputType, int width, int height, Map<String, Object> params) throws ScriptCreationException, FileNotFoundException, ScriptExecuteException {
        this.draw(scriptFile, scriptType, outputType, width, height, false, params);
    }

    public synchronized void draw(String scriptFile, String scriptType, String outputType, int width, int height, boolean isMultiPage, Map<String, Object> params) throws ScriptCreationException, FileNotFoundException, ScriptExecuteException {
        try {
            ScriptFactory factory = this.getScriptFactory();
            factory.enterContext();
            Script script = factory.createScript(scriptFile, scriptType, isMultiPage);
            script.configure(width, height, this.getDataSourceFactory(), factory);
            Chart chart = script.execute(params);
            this.produceOutput(chart, outputType);
            factory.exitContext();
        }
        catch (ScriptCreationException e) {
            throw e;
        }
        catch (FileNotFoundException se) {
            throw se;
        }
        catch (ScriptExecuteException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ScriptExecuteException(e);
        }
    }

    public ScriptFactory getScriptFactory() {
        return this.scriptFactory;
    }

    public void setScriptFactory(ScriptFactory scriptFactory) {
        if (scriptFactory == null) {
            throw new NullPointerException();
        }
        this.scriptFactory = scriptFactory;
    }

    public OutputFactory getOutputFactory() {
        return this.outputFactory;
    }

    public void setOutputFactory(OutputFactory outputFactory) {
        if (outputFactory == null) {
            throw new NullPointerException();
        }
        this.outputFactory = outputFactory;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        if (dataSourceFactory == null) {
            throw new NullPointerException();
        }
        this.dataSourceFactory = dataSourceFactory;
    }

    protected abstract void produceOutput(Chart var1, String var2) throws IOException, ScriptExecuteException;

    public synchronized void refresh() {
        this.getScriptFactory().clearCachedScopes();
    }
}

