/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pt.webdetails.cgg.Chart;
import pt.webdetails.cpf.utils.CharsetHelper;

public class SVGChart
implements Chart {
    private Document svg;
    private boolean isMultiPage;

    public SVGChart(Document doc, boolean isMultiPage) {
        if (doc == null) {
            throw new NullPointerException();
        }
        this.svg = doc;
        this.isMultiPage = isMultiPage;
    }

    @Override
    public Document getRawObject() {
        return this.svg;
    }

    @Override
    public void renderAsPng(OutputStream out) throws IOException {
        if (this.isMultiPage) {
            this.renderPages(out, false);
        } else {
            this.renderPageAsPng(out, this.svg);
        }
    }

    @Override
    public void renderAsSVG(OutputStream out) throws IOException {
        if (this.isMultiPage) {
            this.renderPages(out, true);
        } else {
            this.renderPageAsSVG(out, this.svg);
        }
    }

    private void renderPages(OutputStream out, boolean isAsSvg) throws IOException {
        Element rootElem = this.svg.getDocumentElement();
        NodeList pageNodeList = rootElem.getChildNodes();
        int pageCount = pageNodeList.getLength();
        Node[] pageNodes = new Node[pageCount];
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            pageNodes[pageIndex] = pageNodeList.item(pageIndex);
        }
        while (rootElem.getLastChild() != null) {
            rootElem.removeChild(rootElem.getLastChild());
        }
        MimeMultipart multiPart = new MimeMultipart();
        try {
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                rootElem.appendChild(pageNodes[pageIndex]);
                ByteArrayOutputStream pageOutputStream = new ByteArrayOutputStream();
                if (isAsSvg) {
                    this.renderPageAsSVG(pageOutputStream, this.svg);
                } else {
                    this.renderPageAsPng(pageOutputStream, this.svg);
                }
                MimeBodyPart bodyPart = new MimeBodyPart();
                String mime_type = isAsSvg ? "image/svg+xml" : "image/png";
                bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(pageOutputStream.toByteArray(), mime_type)));
                bodyPart.setHeader("Content-Type", mime_type);
                bodyPart.setFileName("export_" + pageIndex + (isAsSvg ? ".svg" : ".png"));
                multiPart.addBodyPart((BodyPart)bodyPart);
                rootElem.removeChild(pageNodes[pageIndex]);
            }
            multiPart.writeTo(out);
        }
        catch (MessagingException ex) {
            throw new IOException("Cannot render page", ex);
        }
    }

    private void renderPageAsPng(OutputStream out, Document pageSvg) throws IOException {
        PNGTranscoder t = new PNGTranscoder();
        TranscoderInput input = new TranscoderInput(pageSvg);
        TranscoderOutput output = new TranscoderOutput(out);
        try {
            t.transcode(input, output);
            out.flush();
        }
        catch (TranscoderException ex) {
            throw new IOException("Failed to transcode image", ex);
        }
    }

    private void renderPageAsSVG(OutputStream out, Document pageSvg) throws IOException {
        SVGTranscoder t = new SVGTranscoder();
        TranscoderInput input = new TranscoderInput(pageSvg);
        TranscoderOutput output = new TranscoderOutput((Writer)new OutputStreamWriter(out, CharsetHelper.getEncoding()));
        try {
            t.transcode(input, output);
            out.flush();
        }
        catch (TranscoderException ex) {
            throw new IOException("Failed to transcode image", ex);
        }
    }
}

