/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.datasources;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cgg.datasources.DataSource;
import pt.webdetails.cgg.datasources.DataSourceFactory;

public class DefaultDataSourceFactory
implements DataSourceFactory {
    private static final DefaultDataSourceFactory instance = new DefaultDataSourceFactory();
    private HashMap<String, String> handlerRegistry = new HashMap();
    protected static final Log logger = LogFactory.getLog(DefaultDataSourceFactory.class);

    public static DefaultDataSourceFactory getInstance() {
        return instance;
    }

    private DefaultDataSourceFactory() {
    }

    public void register(String name, Class<? extends DataSource> handler) {
        this.handlerRegistry.put(name, handler.getName());
    }

    @Override
    public DataSource createDatasource(String type) {
        String className = this.handlerRegistry.get(type);
        if (className == null) {
            throw new IllegalArgumentException();
        }
        DataSource datasource = this.getSource(className);
        if (datasource == null) {
            throw new IllegalArgumentException();
        }
        return datasource;
    }

    private DataSource getSource(String type) {
        try {
            return (DataSource)Class.forName(type).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            logger.fatal((Object)("Class for data source " + type + " not found."), (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            logger.fatal((Object)"Instantiaton of class failed", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            logger.fatal((Object)"Illegal access to datasource class", (Throwable)iae);
        }
        return null;
    }
}

