/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.output;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cgg.output.OutputFactory;
import pt.webdetails.cgg.output.OutputHandler;

public class DefaultOutputFactory
implements OutputFactory {
    private static final DefaultOutputFactory instance = new DefaultOutputFactory();
    private HashMap<String, String> handlerRegistry = new HashMap();
    protected static final Log logger = LogFactory.getLog(DefaultOutputFactory.class);

    public static DefaultOutputFactory getInstance() {
        return instance;
    }

    private DefaultOutputFactory() {
    }

    public void register(String name, Class<? extends OutputHandler> handler) {
        this.handlerRegistry.put(name, handler.getName());
    }

    @Override
    public OutputHandler create(String type) {
        String className = this.handlerRegistry.get(type);
        if (className == null) {
            throw new IllegalArgumentException("No Registered handler for type " + type);
        }
        OutputHandler outputHandler = this.getHandler(className);
        if (outputHandler == null) {
            throw new IllegalArgumentException();
        }
        return outputHandler;
    }

    private OutputHandler getHandler(String type) {
        try {
            return (OutputHandler)Class.forName(type).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            logger.fatal((Object)("Class for output handler " + type + " not found."), (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            logger.fatal((Object)"Instantiaton of class failed", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            logger.fatal((Object)"Illegal access to outputhandler class", (Throwable)iae);
        }
        return null;
    }
}

