/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DefaultFontFamilyResolver;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import pt.webdetails.cgg.scripts.ScriptFactory;
import pt.webdetails.cgg.scripts.ScriptResourceNotFoundException;

public class BaseScope
extends ImporterTopLevel {
    private static final long serialVersionUID = 8594060356268613175L;
    protected static final Log logger = LogFactory.getLog(BaseScope.class);
    protected boolean sealedStdLib = false;
    private boolean initialized;
    private ScriptFactory scriptFactory;
    private HashMap<String, Script> userScripts = new HashMap();
    private HashMap<String, Script> processed = new HashMap();

    public void init(Context cx) {
        if (!this.initialized) {
            this.initStandardObjects(cx, this.sealedStdLib);
            String[] names = new String[]{"print", "load", "lib", "_loadSvg", "_xmlToString", "getTextLenCGG", "getTextHeightCGG", "res", "readResource"};
            this.defineFunctionProperties(names, BaseScope.class, 2);
            this.initialized = true;
        }
    }

    public static Object print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (Object arg : args) {
            String s = Context.toString((Object)arg);
            logger.info((Object)s);
        }
        return Context.getUndefinedValue();
    }

    public static Object load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object arg = BaseScope.unwrapFirstArgument(args[0]);
        if (arg == null) {
            return Context.toBoolean((Object)false);
        }
        try {
            String file = arg.toString();
            BaseScope scope = (BaseScope)thisObj;
            return Context.toBoolean((Object)scope.loadScript(cx, file));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to call 'load'", (Throwable)e);
            return Context.toBoolean((Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadScript(Context cx, String file) throws IOException, ScriptResourceNotFoundException {
        if (file == null) {
            return false;
        }
        String contextResourceURI = this.scriptFactory.getContextResourceURI(file);
        Script s = this.userScripts.get(contextResourceURI);
        if (s == null) {
            try (Reader contextLibraryScript = this.scriptFactory.getContextLibraryScript(file);){
                logger.info((Object)("Compiled context reader for " + file));
                s = cx.compileReader(contextLibraryScript, file, 1, null);
                this.userScripts.put(contextResourceURI, s);
            }
        }
        if (s != null) {
            s.exec(cx, (Scriptable)this);
        }
        return true;
    }

    private static Object unwrapFirstArgument(Object arg) {
        if (arg instanceof NativeJavaObject) {
            NativeJavaObject no = (NativeJavaObject)arg;
            return no.unwrap();
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object _loadSvg(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object object;
        Object arg = BaseScope.unwrapFirstArgument(args[0]);
        if (arg == null) {
            return Context.toBoolean((Object)false);
        }
        String file = arg.toString();
        BaseScope scope = (BaseScope)thisObj;
        String parser = "org.apache.xerces.parsers.SAXParser";
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory("org.apache.xerces.parsers.SAXParser");
        String uri = scope.scriptFactory.getContextResourceURI(file);
        InputStream stream = scope.scriptFactory.getContextResource(file);
        try {
            SVGOMDocument doc = (SVGOMDocument)f.createDocument(uri, stream);
            SVGDOMImplementation impl = (SVGDOMImplementation)SVGDOMImplementation.getDOMImplementation();
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            new GVTBuilder().build(ctx, (Document)doc);
            CSSEngine eng = impl.createCSSEngine((AbstractStylableDocument)doc, (CSSContext)ctx);
            doc.setCSSEngine(eng);
            object = Context.javaToJS((Object)doc, (Scriptable)scope);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to call '_loadSVG'", (Throwable)e);
                return Context.getUndefinedValue();
            }
        }
        stream.close();
        return object;
    }

    public static Object lib(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object arg = BaseScope.unwrapFirstArgument(args[0]);
        if (arg == null) {
            return Context.toBoolean((Object)false);
        }
        try {
            String file = arg.toString();
            BaseScope scope = (BaseScope)thisObj;
            return Context.toBoolean((Object)scope.loadSystemScript(cx, file));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to call 'lib'", (Throwable)e);
            return Context.toBoolean((Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSystemScript(Context cx, String file) throws IOException, ScriptResourceNotFoundException {
        if (file == null) {
            return false;
        }
        String contextResourceURI = file;
        Script s = this.processed.get(contextResourceURI);
        if (s == null) {
            try (Reader script = this.scriptFactory.getSystemLibraryScript(file);){
                logger.info((Object)("Compiled system reader for " + file));
                s = cx.compileReader(script, file, 1, null);
                this.processed.put(contextResourceURI, s);
            }
        }
        if (s != null) {
            s.exec(cx, (Scriptable)this);
        }
        return true;
    }

    public static Object readResource(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object arg = BaseScope.unwrapFirstArgument(args[0]);
        if (arg == null) {
            return Context.toString((Object)"");
        }
        try {
            String url = arg.toString();
            BaseScope scope = (BaseScope)thisObj;
            return Context.toString((Object)scope.readResourceAsText(cx, url));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to call 'load'", (Throwable)e);
            return Context.toBoolean((Object)false);
        }
    }

    public String readResourceAsText(Context cx, String file) {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.scriptFactory.getWebResource(file)));
            StringBuilder textBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                textBuilder.append(line);
            }
            bufferedReader.close();
            return textBuilder.toString();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to call 'readResourceAsText'", (Throwable)e);
            return null;
        }
    }

    public static Object res(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return BaseScope.load(cx, thisObj, args, funObj);
    }

    public static Object _xmlToString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object arg = BaseScope.unwrapFirstArgument(args[0]);
        Node node = (Node)arg;
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
            BaseScope scope = (BaseScope)thisObj;
            return Context.javaToJS((Object)stringWriter.getBuffer().toString(), (Scriptable)scope);
        }
        catch (TransformerConfigurationException e) {
            logger.warn((Object)"Failed to call '_xmlToString'", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.warn((Object)"Failed to call '_xmlToString'", (Throwable)e);
        }
        return null;
    }

    public void setScriptFactory(ScriptFactory scriptFactory) {
        this.scriptFactory = scriptFactory;
    }

    public static Object getTextLenCGG(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        try {
            String text = Context.toString((Object)args[0]);
            String fontFamily = Context.toString((Object)args[1]);
            String fontSize = Context.toString((Object)args[2]).trim();
            String fontStyle = "normal";
            String fontWeight = "normal";
            if (args.length > 3) {
                fontStyle = Context.toString((Object)args[3]);
                if (args.length > 4) {
                    fontWeight = Context.toString((Object)args[4]);
                }
            }
            Font ffont = BaseScope.getFont(fontFamily, fontSize, fontStyle, fontWeight);
            JLabel label = new JLabel();
            FontMetrics fMetric = label.getFontMetrics(ffont);
            int width = fMetric.stringWidth(text);
            return Context.toNumber((Object)width);
        }
        catch (RuntimeException e) {
            logger.warn((Object)"Failed to call 'getTextLenCGG'", (Throwable)e);
            return Context.toNumber((Object)0);
        }
    }

    public static Object getTextHeightCGG(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        try {
            String fontFamily = Context.toString((Object)args[1]);
            String fontSize = Context.toString((Object)args[2]).trim();
            String fontStyle = "normal";
            String fontWeight = "normal";
            if (args.length > 3) {
                fontStyle = Context.toString((Object)args[3]);
                if (args.length > 4) {
                    fontWeight = Context.toString((Object)args[4]);
                }
            }
            Font ffont = BaseScope.getFont(fontFamily, fontSize, fontStyle, fontWeight);
            JLabel label = new JLabel();
            FontMetrics fMetric = label.getFontMetrics(ffont);
            int height = fMetric.getHeight();
            return Context.toNumber((Object)height);
        }
        catch (RuntimeException e) {
            logger.warn((Object)"Failed to call 'getTextHeightCGG'", (Throwable)e);
            return Context.toNumber((Object)10);
        }
    }

    private static Font getFont(String fontFamily, String fontSize, String fontStyle, String fontWeight) {
        boolean convert = false;
        if (fontSize.endsWith("px")) {
            fontSize = fontSize.substring(0, fontSize.length() - 2);
        } else if (fontSize.endsWith("pt")) {
            fontSize = fontSize.substring(0, fontSize.length() - 2);
        }
        float size = 15.0f;
        try {
            size = Integer.parseInt(fontSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int isize = Math.round(size);
        if (convert) {
            size = 0.75f * size;
            int screenDpi = Toolkit.getDefaultToolkit().getScreenResolution();
            isize = Math.round(size * (float)screenDpi / 72.0f);
        }
        int javaFontStyle = BaseScope.parseCssFontStyleAndWeight(fontStyle, fontWeight);
        return BaseScope.decodeFont(fontFamily, javaFontStyle, isize);
    }

    private static int parseCssFontStyleAndWeight(String fontStyle, String fontWeight) {
        boolean isItalic = false;
        boolean isBold = false;
        if (fontStyle != null && ((fontStyle = fontStyle.toLowerCase()).equals("italic") || fontStyle.equals("oblique"))) {
            isItalic = true;
        }
        if (fontWeight != null && ((fontWeight = fontWeight.toLowerCase()).equals("bold") || fontWeight.equals("bolder") || fontWeight.equals("700") || fontWeight.equals("800") || fontWeight.equals("900"))) {
            isBold = true;
        }
        if (isItalic) {
            return isBold ? 3 : 2;
        }
        return isBold ? 1 : 0;
    }

    private static Font decodeFont(String fontFamily, int fontStyle, int isize) {
        String fontStyleText = "";
        switch (fontStyle) {
            case 1: {
                fontStyleText = "BOLD ";
                break;
            }
            case 2: {
                fontStyleText = "ITALIC ";
                break;
            }
            case 3: {
                fontStyleText = "BOLDITALIC ";
            }
        }
        String capFontFamily = fontFamily.substring(0, 1).toUpperCase() + fontFamily.substring(1, fontFamily.length());
        Font ffont = Font.decode(capFontFamily + " " + fontStyleText + isize);
        if (ffont.getFamily().equals("Dialog") && !fontFamily.equals("dialog")) {
            GVTFontFamily awtFamily = DefaultFontFamilyResolver.SINGLETON.resolve(fontFamily);
            if (awtFamily == null) {
                awtFamily = DefaultFontFamilyResolver.SINGLETON.getDefault();
            }
            ffont = new Font(awtFamily.getFamilyName(), fontStyle, isize);
        }
        return ffont;
    }
}

