/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import pt.webdetails.cgg.scripts.ScriptResourceLoader;
import pt.webdetails.cgg.scripts.ScriptResourceNotFoundException;

public class CompoundScriptResourceLoader
implements ScriptResourceLoader {
    private ArrayList<ScriptResourceLoader> loaders = new ArrayList();

    public CompoundScriptResourceLoader() {
    }

    public CompoundScriptResourceLoader(ScriptResourceLoader ... loaders) {
        this();
        for (ScriptResourceLoader loader : loaders) {
            this.add(loader);
        }
    }

    public void add(ScriptResourceLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this.loaders.add(loader);
    }

    public void remove(ScriptResourceLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this.loaders.remove(loader);
    }

    public int size() {
        return this.loaders.size();
    }

    public ScriptResourceLoader get(int i) {
        return this.loaders.get(i);
    }

    @Override
    public Reader getSystemLibraryScript(String script) throws IOException, ScriptResourceNotFoundException {
        for (ScriptResourceLoader loader : this.loaders) {
            try {
                return loader.getSystemLibraryScript(script);
            }
            catch (ScriptResourceNotFoundException scriptResourceNotFoundException) {
            }
        }
        throw new ScriptResourceNotFoundException(script);
    }

    @Override
    public Reader getContextLibraryScript(String script) throws IOException, ScriptResourceNotFoundException {
        for (ScriptResourceLoader loader : this.loaders) {
            try {
                return loader.getContextLibraryScript(script);
            }
            catch (ScriptResourceNotFoundException scriptResourceNotFoundException) {
            }
        }
        throw new ScriptResourceNotFoundException(script);
    }

    @Override
    public String getContextResourceURI(String script) throws IOException, ScriptResourceNotFoundException {
        for (ScriptResourceLoader loader : this.loaders) {
            try {
                return loader.getContextResourceURI(script);
            }
            catch (ScriptResourceNotFoundException scriptResourceNotFoundException) {
            }
        }
        throw new ScriptResourceNotFoundException(script);
    }

    @Override
    public InputStream getContextResource(String script) throws IOException, ScriptResourceNotFoundException {
        for (ScriptResourceLoader loader : this.loaders) {
            try {
                return loader.getContextResource(script);
            }
            catch (ScriptResourceNotFoundException scriptResourceNotFoundException) {
            }
        }
        throw new ScriptResourceNotFoundException(script);
    }

    @Override
    public InputStream getWebResource(String script) throws IOException, ScriptResourceNotFoundException {
        for (ScriptResourceLoader loader : this.loaders) {
            try {
                return loader.getWebResource(script);
            }
            catch (ScriptResourceNotFoundException scriptResourceNotFoundException) {
            }
        }
        throw new ScriptResourceNotFoundException(script);
    }
}

