/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.ui.core.database.dialog.GetQueryFieldsProgressDialog;
import org.pentaho.di.ui.core.database.dialog.StepFieldNode;
import org.pentaho.di.ui.core.database.dialog.XulStepFieldsModel;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class XulStepFieldsController
extends AbstractXulEventHandler {
    private Shell shell;
    private DatabaseMeta databaseMeta;
    private String schemaTableCombo;
    private BindingFactory bf;
    private Binding stepFieldsTreeBinding;
    private Binding stepNameBinding;
    private Binding acceptButtonBinding;
    private XulTree stepFieldsTree;
    private XulStepFieldsModel model;
    private Boolean showAcceptButton;
    private RowMetaInterface rowMetaInterface;

    public XulStepFieldsController(Shell aShell, DatabaseMeta aDatabaseMeta, String schemaTableCombo, RowMetaInterface anInput) {
        this.shell = aShell;
        this.databaseMeta = aDatabaseMeta;
        this.schemaTableCombo = schemaTableCombo;
        this.bf = new DefaultBindingFactory();
        this.model = new XulStepFieldsModel();
        this.rowMetaInterface = anInput;
    }

    public void init() {
        this.createStepFieldNodes();
        this.bf.setDocument(this.document);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.stepFieldsTree = (XulTree)this.document.getElementById("step_fields_data");
        this.stepFieldsTreeBinding = this.bf.createBinding((Object)this.model, "stepFields", (Object)this.stepFieldsTree, "elements", new BindingConvertor[0]);
        this.stepNameBinding = this.bf.createBinding((Object)this.model, "stepName", "stepNameLabel", "value", new BindingConvertor[0]);
        this.acceptButtonBinding = this.bf.createBinding((Object)this, "showAcceptButton", "stepFieldsDialog_accept", "visible", new BindingConvertor[0]);
        if (this.getShowAcceptButton()) {
            BindingConvertor<StepFieldNode, Boolean> isDisabledConvertor = new BindingConvertor<StepFieldNode, Boolean>(){

                public Boolean sourceToTarget(StepFieldNode value) {
                    return value == null;
                }

                public StepFieldNode targetToSource(Boolean value) {
                    return null;
                }
            };
            this.acceptButtonBinding = this.bf.createBinding((Object)this.stepFieldsTree, "selectedItem", "stepFieldsDialog_accept", "disabled", new BindingConvertor[]{isDisabledConvertor});
        }
        this.fireBindings();
    }

    public void cancelDialog() {
        XulDialog theDialog = (XulDialog)this.document.getElementById("stepFieldsDialog");
        theDialog.setVisible(false);
    }

    public void setShowAcceptButton(boolean isVisible) {
        this.showAcceptButton = isVisible;
    }

    public boolean getShowAcceptButton() {
        return this.showAcceptButton;
    }

    private void createStepFieldNodes() {
        if (this.rowMetaInterface == null) {
            String theSql = this.databaseMeta.getSQLQueryFields(this.schemaTableCombo);
            GetQueryFieldsProgressDialog theProgressDialog = new GetQueryFieldsProgressDialog(this.shell, this.databaseMeta, theSql);
            this.rowMetaInterface = theProgressDialog.open();
        }
        this.model.setStepName("Step name:" + this.schemaTableCombo);
        if (this.rowMetaInterface != null) {
            StepFieldNode theStep = null;
            for (int i = 0; i < this.rowMetaInterface.size(); ++i) {
                theStep = new StepFieldNode();
                ValueMetaInterface theMetaInterface = this.rowMetaInterface.getValueMeta(i);
                theStep.setFieldName(theMetaInterface.getName());
                theStep.setType(theMetaInterface.getTypeDesc());
                theStep.setLength(Integer.toString(theMetaInterface.getLength()));
                theStep.setPrecision(Integer.toString(theMetaInterface.getPrecision()));
                theStep.setOrigin(theMetaInterface.getOrigin());
                theStep.setStorageType(Integer.toString(theMetaInterface.getStorageType()));
                theStep.setConversionMask(theMetaInterface.getConversionMask());
                theStep.setDecimalSymbol(theMetaInterface.getDecimalSymbol());
                theStep.setGroupingSymbol(theMetaInterface.getGroupingSymbol());
                theStep.setTrimType(Integer.toString(theMetaInterface.getTrimType()));
                theStep.setComments(theMetaInterface.getComments());
                this.model.addStepField(theStep);
            }
        }
    }

    public void editOriginStep() {
        StepFieldNode theSelectedStep = (StepFieldNode)((Object)this.stepFieldsTree.getSelectedItem());
        if (theSelectedStep != null) {
            XulDialog theStepsDialog = (XulDialog)this.document.getElementById("stepFieldsDialog");
            theStepsDialog.hide();
        }
    }

    public String getSelectedStep() {
        return this.schemaTableCombo;
    }

    public String getName() {
        return "stepFields";
    }

    private void fireBindings() {
        try {
            this.stepFieldsTreeBinding.fireSourceChanged();
            this.stepNameBinding.fireSourceChanged();
            this.acceptButtonBinding.fireSourceChanged();
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error firing bindings", (Throwable)e);
        }
    }
}

