/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.HelpUtils;

public class ArgumentsDialog
extends Dialog {
    private static Class<?> PKG = ArgumentsDialog.class;
    private TableView wArguments;
    private ExecutionConfiguration configuration;
    private Shell shell;
    private Display display;
    private PropsUI props;

    public ArgumentsDialog(final Shell parent, ExecutionConfiguration configuration, AbstractMeta abstractMeta) {
        super(parent);
        this.configuration = configuration;
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, 67808);
        this.props = PropsUI.getInstance();
        this.props.setLook((Control)this.shell);
        this.shell.setImage(parent.getImage());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)"ArgumentsDialog.Arguments.Label", (String[])new String[0]));
        ColumnInfo[] cArguments = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ArgumentsDialog.ArgumentsColumn.Argument", (String[])new String[0]), 1, false, true, 180), new ColumnInfo(BaseMessages.getString(PKG, (String)"ArgumentsDialog.ArgumentsColumn.Value", (String[])new String[0]), 1, false, false, 172)};
        int nrArguments = configuration.getArguments() != null ? configuration.getArguments().size() : 0;
        this.wArguments = new TableView((VariableSpace)abstractMeta, (Composite)this.shell, 67586, cArguments, nrArguments, false, null, this.props, false);
        FormData fd_argumentsTable = new FormData();
        fd_argumentsTable.top = new FormAttachment(0, 15);
        fd_argumentsTable.left = new FormAttachment(0, 15);
        fd_argumentsTable.bottom = new FormAttachment(0, 221);
        fd_argumentsTable.right = new FormAttachment(0, 371);
        this.wArguments.setLayoutData(fd_argumentsTable);
        Label separator = new Label((Composite)this.shell, 258);
        FormData fd_separator = new FormData();
        fd_separator.top = new FormAttachment((Control)this.wArguments, 15);
        fd_separator.right = new FormAttachment((Control)this.wArguments, 0, 131072);
        fd_separator.left = new FormAttachment(0, 15);
        separator.setLayoutData((Object)fd_separator);
        Button okButton = new Button((Composite)this.shell, 0);
        okButton.setText("OK");
        FormData fd_okButton = new FormData();
        fd_okButton.left = Const.isOSX() ? new FormAttachment(0, 215) : new FormAttachment(0, 269);
        okButton.setLayoutData((Object)fd_okButton);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArgumentsDialog.this.ok();
            }
        });
        Button cancelButton = new Button((Composite)this.shell, 0);
        fd_okButton.top = new FormAttachment((Control)cancelButton, 0, 128);
        fd_okButton.right = new FormAttachment((Control)cancelButton, -4);
        cancelButton.setText("Cancel");
        FormData fd_cancelButton = new FormData();
        fd_cancelButton.top = new FormAttachment((Control)separator, 13);
        fd_cancelButton.right = new FormAttachment((Control)this.wArguments, 0, 131072);
        cancelButton.setLayoutData((Object)fd_cancelButton);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArgumentsDialog.this.dispose();
            }
        });
        Button btnHelp = new Button((Composite)this.shell, 0);
        btnHelp.setImage(GUIResource.getInstance().getImageHelpWeb());
        btnHelp.setText(BaseMessages.getString(PKG, (String)"System.Button.Help", (String[])new String[0]));
        btnHelp.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        FormData fd_btnHelp = new FormData();
        fd_btnHelp.top = new FormAttachment((Control)separator, 13);
        fd_btnHelp.left = new FormAttachment((Control)separator, 0, 16384);
        btnHelp.setLayoutData((Object)fd_btnHelp);
        btnHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String docUrl = Const.getDocUrl((String)BaseMessages.getString(Spoon.class, (String)"Spoon.ArgumentsDialog.Help", (String[])new String[0]));
                String docTitle = BaseMessages.getString((Class)PKG, (String)"ArgumentsDialog.docTitle", (String[])new String[0]);
                String docHeader = BaseMessages.getString((Class)PKG, (String)"ArgumentsDialog.docHeader", (String[])new String[0]);
                HelpUtils.openHelpDialog(parent.getShell(), docTitle, docUrl, docHeader);
            }
        });
        this.shell.setSize(394, 319);
        this.getArgumentsData();
        this.shell.open();
        Rectangle shellBounds = this.getParent().getBounds();
        Point dialogSize = this.shell.getSize();
        this.shell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void checkSubclass() {
    }

    private void getArgumentsData() {
        this.wArguments.clearAll(false);
        ArrayList argumentNames = new ArrayList(this.configuration.getArguments().keySet());
        Collections.sort(argumentNames);
        for (int i = 0; i < argumentNames.size(); ++i) {
            String argumentName = (String)argumentNames.get(i);
            String argumentValue = (String)this.configuration.getArguments().get(argumentName);
            TableItem tableItem = new TableItem(this.wArguments.table, 0);
            tableItem.setText(1, Const.NVL((String)argumentName, (String)""));
            tableItem.setText(2, Const.NVL((String)argumentValue, (String)""));
        }
        this.wArguments.removeEmptyRows();
        this.wArguments.setRowNums();
        this.wArguments.optWidth(true);
    }

    private void getInfoArguments() {
        HashMap<String, String> map = new HashMap<String, String>();
        int nrNonEmptyArguments = this.wArguments.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyArguments; ++i) {
            TableItem tableItem = this.wArguments.getNonEmpty(i);
            String varName = tableItem.getText(1);
            String varValue = tableItem.getText(2);
            if (Utils.isEmpty((CharSequence)varName)) continue;
            map.put(varName, varValue);
        }
        this.configuration.setArguments(map);
    }

    protected void ok() {
        if (Const.isOSX()) {
            this.wArguments.applyOSXChanges();
        }
        this.getInfoArguments();
        this.dispose();
    }

    private void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

