/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ColumnsResizer
implements Listener {
    private int[] weights;
    private boolean resizing;

    public ColumnsResizer(int ... weights) {
        this.weights = weights;
    }

    public void handleEvent(Event event) {
        Table table = (Table)event.widget;
        this.applyWeigths(table);
    }

    public void addColumnResizeListeners(Table table) {
        TableColumn[] columns = table.getColumns();
        int len = Math.min(this.weights.length, columns.length);
        for (int i = 0; i < len - 1; ++i) {
            if (this.weights[i] <= 0) continue;
            columns[i].addListener(11, this.getColumnResizeListener(i));
        }
    }

    private Listener getColumnResizeListener(final int colIndex) {
        return new Listener(){
            private int colIdx;
            {
                this.colIdx = colIndex;
            }

            public void handleEvent(Event event) {
                if (ColumnsResizer.this.resizing) {
                    return;
                }
                TableColumn column = (TableColumn)event.widget;
                Table table = column.getParent();
                TableColumn[] columns = table.getColumns();
                int firstWidth = 0;
                int restWidth = 0;
                int len = Math.min(ColumnsResizer.this.weights.length, columns.length);
                for (int i = 0; i <= this.colIdx; ++i) {
                    firstWidth += columns[i].getWidth();
                }
                float restWeightsBefore = 0.0f;
                for (int i = this.colIdx + 1; i < len; ++i) {
                    restWeightsBefore += (float)ColumnsResizer.this.weights[i];
                    restWidth += columns[i].getWidth();
                }
                int tableWidth = ColumnsResizer.this.getTableWidth(table);
                int minWeight = 4;
                for (int i = 0; i <= this.colIdx; ++i) {
                    if (ColumnsResizer.this.weights[i] <= 0) continue;
                    ((ColumnsResizer)ColumnsResizer.this).weights[i] = columns[i].getWidth();
                }
                int columnsWidth = firstWidth + restWidth;
                int shortening = columnsWidth - tableWidth;
                float newRestWidth = restWidth - shortening;
                for (int i = this.colIdx + 1; i < len; ++i) {
                    if (ColumnsResizer.this.weights[i] <= 0) continue;
                    float w = ColumnsResizer.this.weights[i];
                    w = w / restWeightsBefore * newRestWidth;
                    ((ColumnsResizer)ColumnsResizer.this).weights[i] = Math.max(Math.round(w), 4);
                }
                ColumnsResizer.this.applyWeigths(table);
            }
        };
    }

    protected void applyWeigths(Table table) {
        if (this.resizing) {
            return;
        }
        float width = this.getTableWidth(table);
        TableColumn[] columns = table.getColumns();
        int f = 0;
        for (int w : this.weights) {
            f += w;
        }
        int len = Math.min(this.weights.length, columns.length);
        this.resizing = true;
        for (int i = 0; i < len; ++i) {
            int cw = this.weights[i] == 0 ? 0 : Math.round(width / (float)f * (float)this.weights[i]);
            width -= (float)(cw + 1);
            columns[i].setWidth(cw);
            f -= this.weights[i];
        }
        this.resizing = false;
    }

    protected int getTableWidth(Table table) {
        int width = table.getSize().x - 2;
        if (table.getVerticalBar() != null && table.getVerticalBar().isVisible()) {
            width -= table.getVerticalBar().getSize().x;
        }
        return width;
    }
}

