/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class VFSFileSelection
extends Composite {
    private static final Class<?> PKG = VFSFileSelection.class;
    public final TextVar wFileName;
    public final Button wBrowse;
    private final String[] fileFilters;
    private final String[] fileFilterNames;
    private final TransMeta transMeta;
    private final Repository repository;
    private final Supplier<Optional<String>> fileNameSupplier;

    public VFSFileSelection(Composite composite, int i, String[] fileFilters, String[] fileFilterNames, TransMeta transMeta) {
        this(composite, i, fileFilters, fileFilterNames, transMeta, null);
    }

    public VFSFileSelection(Composite composite, int i, String[] fileFilters, String[] fileFilterNames, TransMeta transMeta, Repository repository) {
        super(composite, i);
        this.fileFilters = fileFilters;
        this.fileFilterNames = fileFilterNames;
        this.transMeta = transMeta;
        this.repository = repository;
        this.fileNameSupplier = repository == null ? this::promptForLocalFile : this::promptForRepositoryFile;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        this.wFileName = new TextVar((VariableSpace)transMeta, this, 18436);
        FormData fdFileName = new FormData();
        fdFileName.left = new FormAttachment(0, 0);
        fdFileName.top = new FormAttachment(0, 0);
        fdFileName.width = 275;
        this.wFileName.setLayoutData(fdFileName);
        this.wBrowse = new Button((Composite)this, 8);
        this.wBrowse.setText(BaseMessages.getString(PKG, (String)"VFSFileSelection.Dialog.Browse", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.left = new FormAttachment((Control)this.wFileName, 5);
        fdBrowse.top = new FormAttachment((Control)this.wFileName, 0, 128);
        this.wBrowse.setLayoutData((Object)fdBrowse);
        this.wBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Optional)VFSFileSelection.this.fileNameSupplier.get()).ifPresent(VFSFileSelection.this.wFileName::setText);
            }
        });
    }

    private Optional<String> promptForLocalFile() {
        String curFile = this.transMeta.environmentSubstitute(this.wFileName.getText());
        try {
            FileObject root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
            VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
            FileObject file = vfsFileChooser.open(this.getShell(), null, this.fileFilters, this.fileFilterNames, 0);
            if (file == null) {
                return Optional.empty();
            }
            String filePath = this.getRelativePath(file.getName().toString());
            return Optional.ofNullable(filePath);
        }
        catch (IOException | KettleException e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"VFSFileSelection.ErrorLoadingFile.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VFSFileSelection.ErrorLoadingFile.DialogMessage", (String[])new String[0]), (Exception)e);
            return Optional.empty();
        }
    }

    private String getRelativePath(String filePath) {
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFileObject((String)this.transMeta.environmentSubstitute(this.transMeta.getFilename())).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (filePath != null && parentFolder != null && filePath.startsWith(parentFolder)) {
            filePath = filePath.replace(parentFolder, "${Internal.Entry.Current.Directory}");
        }
        return filePath;
    }

    private Optional<String> promptForRepositoryFile() {
        SelectObjectDialog sod = new SelectObjectDialog(this.getShell(), this.repository);
        String fileName = sod.open();
        RepositoryDirectoryInterface repdir = sod.getDirectory();
        if (fileName != null && repdir != null) {
            String path = this.getRepositoryRelativePath(repdir + "/" + fileName);
            return Optional.ofNullable(path);
        }
        return Optional.empty();
    }

    private String getRepositoryRelativePath(String path) {
        String parentPath = this.transMeta.getRepositoryDirectory().getPath();
        if (path.startsWith(parentPath)) {
            path = path.replace(parentPath, "${Internal.Entry.Current.Directory}");
        }
        return path;
    }
}

