/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.missing;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.missing.MissingEntry;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.spoon.Spoon;

public class MissingEntryDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = MissingEntryDialog.class;
    private Shell shell;
    private Shell shellParent;
    private List<MissingEntry> missingEntries;
    private int mode;
    private PropsUI props;
    private JobEntryInterface jobEntryResult;
    public static final int MISSING_JOB_ENTRIES = 1;
    public static final int MISSING_JOB_ENTRY_ID = 2;

    public MissingEntryDialog(Shell parent, List<MissingEntry> missingEntries) {
        super(parent, null, null, null);
        this.shellParent = parent;
        this.missingEntries = missingEntries;
        this.mode = 1;
    }

    public MissingEntryDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.shellParent = parent;
        this.mode = 2;
    }

    private String getErrorMessage(List<MissingEntry> missingEntries, int mode) {
        String message = "";
        if (mode == 1) {
            StringBuilder entries = new StringBuilder();
            for (MissingEntry entry : missingEntries) {
                if (missingEntries.indexOf(entry) == missingEntries.size() - 1) {
                    entries.append("- " + entry.getName() + " - " + entry.getMissingPluginId() + "\n\n");
                    continue;
                }
                entries.append("- " + entry.getName() + " - " + entry.getMissingPluginId() + "\n");
            }
            message = BaseMessages.getString(PKG, (String)"MissingEntryDialog.MissingJobEntries", (String[])new String[]{entries.toString()});
        }
        if (mode == 2) {
            message = BaseMessages.getString(PKG, (String)"MissingEntryDialog.MissingJobEntryId", (String[])new String[]{this.jobEntryInt.getName() + " - " + ((MissingEntry)this.jobEntryInt).getMissingPluginId()});
        }
        return message;
    }

    public JobEntryInterface open() {
        this.props = PropsUI.getInstance();
        Display display = this.shellParent.getDisplay();
        int margin = 4;
        this.shell = new Shell(this.shellParent, 67681);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginLeft = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"MissingEntryDialog.MissingPlugins", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        Label image = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)image);
        Image icon = display.getSystemImage(4);
        image.setImage(icon);
        FormData imageData = new FormData();
        imageData.left = new FormAttachment(0, 5);
        imageData.right = new FormAttachment(11, 0);
        imageData.top = new FormAttachment(0, 10);
        image.setLayoutData((Object)imageData);
        Label error = new Label((Composite)this.shell, 64);
        this.props.setLook((Control)error);
        error.setText(this.getErrorMessage(this.missingEntries, this.mode));
        FormData errorData = new FormData();
        errorData.left = new FormAttachment((Control)image, 5);
        errorData.right = new FormAttachment(100, -5);
        errorData.top = new FormAttachment(0, 10);
        error.setLayoutData((Object)errorData);
        Label separator = new Label((Composite)this.shell, 64);
        this.props.setLook((Control)separator);
        FormData separatorData = new FormData();
        separatorData.top = new FormAttachment((Control)error, 10);
        separator.setLayoutData((Object)separatorData);
        Button closeButton = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)closeButton);
        FormData fdClose = new FormData();
        fdClose.right = new FormAttachment(98);
        fdClose.top = new FormAttachment((Control)separator);
        closeButton.setLayoutData((Object)fdClose);
        closeButton.setText(BaseMessages.getString(PKG, (String)"MissingEntryDialog.Close", (String[])new String[0]));
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MissingEntryDialog.this.shell.dispose();
                MissingEntryDialog.this.jobEntryResult = null;
            }
        });
        FormData fdSearch = new FormData();
        if (this.mode == 1) {
            Button openButton = new Button((Composite)this.shell, 8);
            this.props.setLook((Control)openButton);
            FormData fdOpen = new FormData();
            fdOpen.right = new FormAttachment((Control)closeButton, -5);
            fdOpen.bottom = new FormAttachment((Control)closeButton, 0, 1024);
            openButton.setLayoutData((Object)fdOpen);
            openButton.setText(BaseMessages.getString(PKG, (String)"MissingEntryDialog.OpenFile", (String[])new String[0]));
            openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MissingEntryDialog.this.shell.dispose();
                    MissingEntryDialog.this.jobEntryResult = (JobEntryInterface)new MissingEntry();
                }
            });
            fdSearch.right = new FormAttachment((Control)openButton, -5);
            fdSearch.bottom = new FormAttachment((Control)openButton, 0, 1024);
        } else {
            fdSearch.right = new FormAttachment((Control)closeButton, -5);
            fdSearch.bottom = new FormAttachment((Control)closeButton, 0, 1024);
        }
        Button searchButton = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)searchButton);
        searchButton.setText(BaseMessages.getString(PKG, (String)"MissingEntryDialog.SearchMarketplace", (String[])new String[0]));
        searchButton.setLayoutData((Object)fdSearch);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MissingEntryDialog.this.shell.dispose();
                    Spoon.getInstance().openMarketplace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntryResult;
    }
}

