/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObjectsList;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulRunner;

public class FileOverwriteDialogController
extends AbstractXulEventHandler {
    private static final String name = "fileOverwriteDialogController";
    private static final Class<?> PKG = RepositoryExplorer.class;
    private static final ResourceBundle resourceBundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    };
    private final XulDomContainer container;
    private final XulDialog dialog;
    private final BindingFactory bf;
    private final UIRepositoryObjectsList objects;
    private boolean overwriteFiles = false;
    private MainController mainController;

    public static FileOverwriteDialogController getInstance(Shell shell, List<UIRepositoryObject> objects) {
        try {
            KettleXulLoader swtLoader = new KettleXulLoader();
            swtLoader.setOuterContext(shell);
            swtLoader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            XulDomContainer container = swtLoader.loadXul("org/pentaho/di/ui/repository/repositoryexplorer/xul/file-overwrite-dialog.xul", resourceBundle);
            SwtXulRunner runner = new SwtXulRunner();
            runner.addContainer(container);
            FileOverwriteDialogController dialogController = new FileOverwriteDialogController(container, objects);
            container.addEventHandler((XulEventHandler)dialogController);
            runner.initialize();
            return dialogController;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected FileOverwriteDialogController(XulDomContainer container, List<UIRepositoryObject> objects) {
        this.container = container;
        this.objects = new UIRepositoryObjectsList(objects);
        this.dialog = (XulDialog)this.container.getDocumentRoot().getElementById("file-overwrite-dialog");
        this.bf = new DefaultBindingFactory();
    }

    public void init() {
        block2: {
            try {
                this.bf.setDocument(this.container.getDocumentRoot());
                this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
                this.bf.setBindingType(Binding.Type.ONE_WAY);
                this.bf.createBinding((Object)this.objects, "children", "file-list", "elements", new BindingConvertor[0]).fireSourceChanged();
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository(e)) break block2;
                new ErrorDialog((Shell)this.container.getOuterContext(), BaseMessages.getString(PKG, (String)"FileOverwriteDialog.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FileOverwriteDialog.ErrorDialog.Message", (String[])new String[0]), e);
            }
        }
    }

    public String getName() {
        return name;
    }

    public void show() {
        this.dialog.show();
    }

    public void closeOverwrite() {
        this.closeCancel();
        this.overwriteFiles = true;
    }

    public void closeCancel() {
        this.dialog.hide();
        this.objects.clear();
    }

    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }
}

