/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree.provider;

import org.eclipse.swt.graphics.Image;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.provider.AutomaticTreeFolderProvider;

public class JobEntriesFolderProvider
extends AutomaticTreeFolderProvider {
    private static Class<?> PKG = Spoon.class;
    public static final String STRING_JOB_ENTRIES = BaseMessages.getString(PKG, (String)"Spoon.STRING_JOB_ENTRIES", (String[])new String[0]);

    @Override
    public String getTitle() {
        return STRING_JOB_ENTRIES;
    }

    @Override
    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        JobMeta jobMeta = (JobMeta)meta;
        for (int i = 0; i < jobMeta.nrJobEntries(); ++i) {
            Image icon;
            JobEntryCopy jobEntry = jobMeta.getJobEntry(i);
            if (!this.filterMatch(jobEntry.getName(), filter) && !this.filterMatch(jobEntry.getDescription(), filter)) continue;
            if (jobEntry.isStart()) {
                icon = GUIResource.getInstance().getImageStartMedium();
            } else if (jobEntry.isDummy()) {
                icon = GUIResource.getInstance().getImageDummyMedium();
            } else {
                String key = jobEntry.getEntry().getPluginId();
                icon = GUIResource.getInstance().getImagesJobentriesSmall().get(key);
            }
            this.createTreeNode(treeNode, jobEntry.getName(), icon);
        }
    }

    @Override
    public Class getType() {
        return JobEntryCopy.class;
    }
}

