/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.repository.dialog.SelectDirectoryDialog;

public class RipDatabaseWizardPage3
extends WizardPage {
    private Label wlJobname;
    private Text wJobname;
    private FormData fdlJobname;
    private FormData fdJobname;
    private Label wlDirectory;
    private Text wDirectory;
    private Button wbDirectory;
    private FormData fdlDirectory;
    private FormData fdbDirectory;
    private FormData fdDirectory;
    private PropsUI props = PropsUI.getInstance();
    private Repository rep;
    private RepositoryDirectoryInterface repositoryDirectory;
    private String directory;
    private Shell shell;

    public RipDatabaseWizardPage3(String arg, Repository rep) {
        super(arg);
        this.rep = rep;
        this.setTitle("Enter the job details");
        this.setDescription("Enter the name of the target job and the directory to put everything in.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        int margin = 4;
        int middle = this.props.getMiddlePct();
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                RipDatabaseWizardPage3.this.setPageComplete(RipDatabaseWizardPage3.this.canFlipToNextPage());
            }
        };
        Composite composite = new Composite(parent, 0);
        this.props.setLook((Control)composite);
        FormLayout compLayout = new FormLayout();
        compLayout.marginHeight = 5;
        compLayout.marginWidth = 5;
        composite.setLayout((Layout)compLayout);
        this.wlJobname = new Label(composite, 131072);
        this.wlJobname.setText("Job name :");
        this.props.setLook((Control)this.wlJobname);
        this.fdlJobname = new FormData();
        this.fdlJobname.left = new FormAttachment(0, 0);
        this.fdlJobname.right = new FormAttachment(middle, -margin);
        this.fdlJobname.top = new FormAttachment(0, margin);
        this.wlJobname.setLayoutData((Object)this.fdlJobname);
        this.wJobname = new Text(composite, 18436);
        this.props.setLook((Control)this.wJobname);
        this.wJobname.addModifyListener(lsMod);
        this.fdJobname = new FormData();
        this.fdJobname.left = new FormAttachment(middle, 0);
        this.fdJobname.top = new FormAttachment(0, margin);
        this.fdJobname.right = new FormAttachment(100, 0);
        this.wJobname.setLayoutData((Object)this.fdJobname);
        this.wlDirectory = new Label(composite, 131072);
        this.wlDirectory.setText("Directory :");
        this.props.setLook((Control)this.wlDirectory);
        this.fdlDirectory = new FormData();
        this.fdlDirectory.left = new FormAttachment(0, 0);
        this.fdlDirectory.right = new FormAttachment(middle, -margin);
        this.fdlDirectory.top = new FormAttachment((Control)this.wJobname, margin);
        this.wlDirectory.setLayoutData((Object)this.fdlDirectory);
        this.wbDirectory = new Button(composite, 8);
        this.wbDirectory.setText("...");
        this.props.setLook((Control)this.wbDirectory);
        this.fdbDirectory = new FormData();
        this.fdbDirectory.right = new FormAttachment(100, 0);
        this.fdbDirectory.top = new FormAttachment((Control)this.wJobname, margin);
        this.wbDirectory.setLayoutData((Object)this.fdbDirectory);
        this.wbDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (RipDatabaseWizardPage3.this.rep != null) {
                    SelectDirectoryDialog sdd = new SelectDirectoryDialog(RipDatabaseWizardPage3.this.shell, 0, RipDatabaseWizardPage3.this.rep);
                    RipDatabaseWizardPage3.this.repositoryDirectory = sdd.open();
                    if (RipDatabaseWizardPage3.this.repositoryDirectory != null) {
                        RipDatabaseWizardPage3.this.wDirectory.setText(RipDatabaseWizardPage3.this.repositoryDirectory.getPath());
                        RipDatabaseWizardPage3.this.setPageComplete(RipDatabaseWizardPage3.this.canFlipToNextPage());
                    }
                } else {
                    DirectoryDialog directoryDialog = new DirectoryDialog(RipDatabaseWizardPage3.this.shell, 0);
                    directoryDialog.setFilterPath(RipDatabaseWizardPage3.this.wDirectory.getText());
                    directoryDialog.setText("Select a target directory");
                    directoryDialog.setMessage("Select the target directory of the job and transformations:");
                    String target = directoryDialog.open();
                    if (target != null) {
                        RipDatabaseWizardPage3.this.wDirectory.setText(target);
                        RipDatabaseWizardPage3.this.directory = target;
                        RipDatabaseWizardPage3.this.setPageComplete(RipDatabaseWizardPage3.this.canFlipToNextPage());
                    }
                }
            }
        });
        this.wDirectory = new Text(composite, 18436);
        this.props.setLook((Control)this.wDirectory);
        this.wDirectory.setEditable(false);
        this.fdDirectory = new FormData();
        this.fdDirectory.left = new FormAttachment(middle, 0);
        this.fdDirectory.top = new FormAttachment((Control)this.wJobname, margin);
        this.fdDirectory.right = new FormAttachment((Control)this.wbDirectory, 0);
        this.wDirectory.setLayoutData((Object)this.fdDirectory);
        this.setControl((Control)composite);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public String getJobname() {
        String jobname = this.wJobname.getText();
        if (jobname != null && jobname.length() == 0) {
            jobname = null;
        }
        return jobname;
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public boolean canFinish() {
        return !Utils.isEmpty((CharSequence)this.getJobname()) && (this.getRepositoryDirectory() != null || !Utils.isEmpty((CharSequence)this.getDirectory()));
    }

    public String getDirectory() {
        return this.directory;
    }
}

