/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step.common;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.common.CsvInputAwareMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.fileinput.text.EncodingType;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputUtils;
import org.pentaho.di.ui.trans.step.common.CsvInputAwareImportProgressDialog;

public interface CsvInputAwareStepDialog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String[] getFieldNames(CsvInputAwareMeta meta) {
        String[] fieldNames = new String[]{};
        InputStream inputStream = this.getInputStream(meta);
        InputStreamReader reader = this.getReader(meta, inputStream);
        try {
            fieldNames = this.getFieldNamesImpl(reader, meta);
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString((String)"Dialog.ErrorGettingFields.Message"), (Exception)((Object)e));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return fieldNames;
    }

    default public String[] getFieldNamesImpl(InputStreamReader reader, CsvInputAwareMeta meta) throws KettleException {
        CharSequence[] fieldNames = new String[]{};
        if (reader == null || meta == null) {
            this.logError(BaseMessages.getString((String)"Dialog.ErrorGettingFields.Message"));
            return fieldNames;
        }
        String delimiter = this.getTransMeta().environmentSubstitute(meta.getDelimiter());
        String enclosure = this.getTransMeta().environmentSubstitute(meta.getEnclosure());
        EncodingType encodingType = EncodingType.guessEncodingType((String)reader.getEncoding());
        String line = TextFileInputUtils.getLine((LogChannelInterface)this.getLogChannel(), (InputStreamReader)reader, (EncodingType)encodingType, (int)meta.getFileFormatTypeNr(), (StringBuilder)new StringBuilder(1000));
        if (!StringUtils.isBlank((String)line)) {
            fieldNames = CsvInput.guessStringsFromLine((LogChannelInterface)this.getLogChannel(), (String)line, (String)delimiter, (String)enclosure, (String)meta.getEscapeCharacter());
        }
        if (Utils.isEmpty((CharSequence[])fieldNames)) {
            this.logError(BaseMessages.getString((String)"Dialog.ErrorGettingFields.Message"));
            return fieldNames;
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = Const.trim((String)fieldNames[i]);
            if (!meta.hasHeader()) {
                DecimalFormat df = new DecimalFormat("000");
                fieldNames[i] = "Field_" + df.format(i);
            } else if (!Utils.isEmpty((CharSequence)meta.getEnclosure()) && ((String)fieldNames[i]).startsWith(meta.getEnclosure()) && ((String)fieldNames[i]).endsWith(meta.getEnclosure()) && ((String)fieldNames[i]).length() > 1) {
                fieldNames[i] = ((String)fieldNames[i]).substring(1, ((String)fieldNames[i]).length() - 1);
            }
            fieldNames[i] = Const.trim((String)fieldNames[i]);
            fieldNames[i] = this.massageFieldName((String)fieldNames[i]);
        }
        return fieldNames;
    }

    default public String massageFieldName(String fieldName) {
        return fieldName;
    }

    public InputStream getInputStream(CsvInputAwareMeta var1);

    default public InputStreamReader getReader(CsvInputAwareMeta meta, InputStream inputStream) {
        InputStreamReader reader = null;
        try {
            String realEncoding = this.getTransMeta().environmentSubstitute(meta.getEncoding());
            reader = Utils.isEmpty((CharSequence)realEncoding) ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, realEncoding);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString((String)"Dialog.ErrorGettingFileDesc.DialogMessage"), e);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String loadFieldsImpl(CsvInputAwareMeta meta, int samples) {
        InputStream inputStream = this.getInputStream(meta);
        try {
            String message;
            InputStreamReader reader = this.getReader(meta, inputStream);
            CsvInputAwareImportProgressDialog pd = this.getCsvImportProgressDialog(meta, samples, reader);
            String string = message = pd.open(false);
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public CsvInputAwareImportProgressDialog getCsvImportProgressDialog(CsvInputAwareMeta var1, int var2, InputStreamReader var3);

    default public void logError(String message, Exception exception) {
        this.getLogChannel().logError(message, (Throwable)exception);
    }

    default public void logError(String message) {
        this.getLogChannel().logError(message);
    }

    public LogChannel getLogChannel();

    public TransMeta getTransMeta();
}

