/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.userdefinedjavaclass;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClass;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UserDefinedJavaClassCodeSnippits {
    private static Class<?> PKG = UserDefinedJavaClass.class;
    private static UserDefinedJavaClassCodeSnippits snippitsHelper = null;
    private final List<Snippit> snippits = new ArrayList<Snippit>();
    private final Map<String, Snippit> snippitsMap = new HashMap<String, Snippit>();
    private final LogChannel log = new LogChannel((Object)"UserDefinedJavaClassCodeSnippits");

    public static synchronized UserDefinedJavaClassCodeSnippits getSnippitsHelper() throws KettleXMLException {
        if (snippitsHelper == null) {
            snippitsHelper = new UserDefinedJavaClassCodeSnippits();
            snippitsHelper.addSnippits("codeSnippits.xml");
        }
        return snippitsHelper;
    }

    private UserDefinedJavaClassCodeSnippits() {
    }

    public void addSnippits(String strFileName) throws KettleXMLException {
        Document doc = XMLHandler.loadXMLFile((InputStream)UserDefinedJavaClassCodeSnippits.class.getResourceAsStream(strFileName), null, (boolean)false, (boolean)false);
        this.buildSnippitList(doc);
    }

    public List<Snippit> getSnippits() {
        return Collections.unmodifiableList(this.snippits);
    }

    public String getDefaultCode() {
        return this.getCode("Implement processRow");
    }

    public String getCode(String snippitName) {
        Snippit snippit = this.snippitsMap.get(snippitName);
        return snippit == null ? "" : snippit.code;
    }

    public String getSample(String snippitName) {
        Snippit snippit = this.snippitsMap.get(snippitName);
        return snippit == null ? "" : snippit.sample;
    }

    private void buildSnippitList(Document doc) {
        List nodes = XMLHandler.getNodes((Node)XMLHandler.getSubNode((Node)doc, (String)"codeSnippits"), (String)"codeSnippit");
        for (Node node : nodes) {
            Snippit snippit = new Snippit(Category.valueOf(XMLHandler.getTagValue((Node)node, (String)"category")), XMLHandler.getTagValue((Node)node, (String)"name"), XMLHandler.getTagValue((Node)node, (String)"sample"), XMLHandler.getTagValue((Node)node, (String)"code"));
            this.snippits.add(snippit);
            Snippit oldSnippit = this.snippitsMap.put(snippit.name, snippit);
            if (oldSnippit == null) continue;
            this.log.logError("Multiple code snippits for name: " + snippit.name);
        }
    }

    static /* synthetic */ Class access$000() {
        return PKG;
    }

    public static class Snippit {
        public final Category category;
        public final String name;
        public final String sample;
        public final String code;

        private Snippit(Category category, String name, String sample, String code) {
            this.category = category;
            this.name = name;
            this.sample = sample;
            this.code = code;
        }
    }

    public static enum Category {
        COMMON(BaseMessages.getString((Class)UserDefinedJavaClassCodeSnippits.access$000(), (String)"UserDefinedJavaClassCodeSnippits.categories.COMMON", (String[])new String[0])),
        STATUS(BaseMessages.getString((Class)UserDefinedJavaClassCodeSnippits.access$000(), (String)"UserDefinedJavaClassCodeSnippits.categories.STATUS", (String[])new String[0])),
        LOGGING(BaseMessages.getString((Class)UserDefinedJavaClassCodeSnippits.access$000(), (String)"UserDefinedJavaClassCodeSnippits.categories.LOGGING", (String[])new String[0])),
        LISTENERS(BaseMessages.getString((Class)UserDefinedJavaClassCodeSnippits.access$000(), (String)"UserDefinedJavaClassCodeSnippits.categories.LISTENERS", (String[])new String[0])),
        ROW(BaseMessages.getString((Class)UserDefinedJavaClassCodeSnippits.access$000(), (String)"UserDefinedJavaClassCodeSnippits.categories.ROW", (String[])new String[0])),
        OTHER(BaseMessages.getString((Class)UserDefinedJavaClassCodeSnippits.access$000(), (String)"UserDefinedJavaClassCodeSnippits.categories.OTHER", (String[])new String[0]));

        private String description;

        private Category(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }
    }
}

