/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model;

import com.infobright.etl.model.BrighthouseRecord;
import com.infobright.etl.model.BrighthouseRecordFactory;
import com.infobright.etl.model.TeradataBinaryRecord;
import com.infobright.etl.model.TextRecord;
import com.infobright.etl.model.datatype.AbstractColumnType;
import com.infobright.logging.EtlLogger;
import java.nio.charset.Charset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataFormat {
    TXT_VARIABLE("txt_variable", "Community", "load data %sinfile '%s' into table %s fields terminated by ',' optionally enclosed by '" + TextRecord.TXT_ENCLOSURE + "' escaped by '\\\\' " + " lines terminated by '" + System.getProperty("line.separator") + "';", new BrighthouseRecordFactory(){

        @Override
        public BrighthouseRecord createRecord(List<AbstractColumnType> columns, Charset charset, EtlLogger logger) {
            return new TextRecord(columns, charset);
        }
    }),
    BINARY("binary", "Enterprise", "load data %sinfile '%s' into table %s;", new BrighthouseRecordFactory(){

        @Override
        public BrighthouseRecord createRecord(List<AbstractColumnType> columns, Charset charset, EtlLogger logger) {
            return new TeradataBinaryRecord(columns, charset, logger);
        }
    });

    private final String bhDataFormat;
    private final String displayText;
    private final String sql;
    private final BrighthouseRecordFactory recordFactory;

    private DataFormat(String bhDataFormat, String displayText, String sql, BrighthouseRecordFactory recordFactory) {
        this.bhDataFormat = bhDataFormat;
        this.displayText = displayText;
        this.sql = sql;
        this.recordFactory = recordFactory;
    }

    public String getBhDataFormat() {
        return this.bhDataFormat;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getLoadSQL(String pipeName, String tableName) {
        return this.getLoadSQL(pipeName, tableName, false);
    }

    public String getLoadSQL(String pipeName, String tableName, boolean useLocalInfile) {
        return String.format(this.sql, useLocalInfile ? "local " : "", pipeName, tableName);
    }

    public static DataFormat valueForDisplayName(String text) {
        if ("Community".equals(text)) {
            return TXT_VARIABLE;
        }
        if ("Enterprise".equals(text)) {
            return BINARY;
        }
        return null;
    }

    public BrighthouseRecord createRecord(List<AbstractColumnType> columns, Charset charset, EtlLogger logger) {
        return this.recordFactory.createRecord(columns, charset, logger);
    }
}

