/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.nio.ByteBuffer;

class VarbinaryType
extends AbstractColumnType {
    private final int maxlength;
    private int length;
    private byte[] data;

    VarbinaryType(int len) {
        if (len > 65535) {
            throw new IllegalArgumentException("length of varbinary must be <=65535");
        }
        this.maxlength = len;
        this.length = 0;
        this.data = new byte[len];
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        this.length = byteBuffer.getShort();
        byteBuffer.get(this.data, 0, this.length);
    }

    public String getDataAsString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            sb.append(String.format("%02x", this.data[i]));
        }
        return sb.toString();
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.putShort((short)this.length);
        byteBuffer.put(this.data, 0, this.length);
    }

    public void setData(String string) {
        int numbytes = string.length() / 2;
        if (this.isCheckValues() && numbytes > this.maxlength) {
            throw new ValueConverterException("data is too big for this column");
        }
        int offset = 0;
        for (int i = 0; i < string.length(); i += 2) {
            String hex = string.substring(i, i + 2);
            this.data[offset++] = (byte)Integer.parseInt(hex, 16);
        }
        this.length = offset;
        this.padZerosStartingAt(numbytes);
    }

    private void padZerosStartingAt(int startIdx) {
        for (int i = startIdx; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    protected void zeroOutData() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        this.length = 0;
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            byte[] bytes = meta.getBinary(value);
            if (bytes == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                if (this.isCheckValues() && bytes.length > this.length) {
                    throw new ValueConverterException("data is too big for this column");
                }
                this.data = bytes;
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return true;
    }
}

