/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import com.infobright.io.NamedPipeFactory;
import com.infobright.io.NamedPipeOutputStream;
import com.infobright.io.PipeCallStrategy;
import com.infobright.logging.EtlLogger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.SQLException;

public class AgentThread
extends Thread {
    static final String OK_MSG = "ok";
    static final String FAIL_MSG = "fail";
    private final long id;
    private final Socket socket;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final EtlLogger logger;

    public AgentThread(Socket socket, long id, EtlLogger logger) throws IOException {
        this.socket = socket;
        this.in = new DataInputStream(socket.getInputStream());
        this.out = new DataOutputStream(socket.getOutputStream());
        this.logger = logger;
        this.id = id;
    }

    public long getWorkerId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        OutputStream outStr = null;
        InetAddress clientAddr = this.socket.getInetAddress();
        String clientInfo = clientAddr.getHostName() + " (" + clientAddr.getHostAddress() + ")";
        try {
            if (this.logger != null) {
                this.logger.info("[" + this.id + "] Client connection received from " + clientInfo);
            }
            this.out.writeUTF(System.getProperty("os.name"));
            String pipeName = this.in.readUTF();
            if (this.logger != null) {
                this.logger.debug("[" + this.id + "] Using pipeName \"" + pipeName + "\"");
            }
            try {
                outStr = this.createOutputStream(pipeName);
            }
            catch (Exception e) {
                this.out.writeUTF(FAIL_MSG);
                throw e;
            }
            this.out.writeUTF(OK_MSG);
            if (this.logger != null) {
                this.logger.debug("[" + this.id + "] Created output stream");
            }
            byte[] oneByte = new byte[1];
            long counter = 0L;
            int data = this.in.read();
            while (data != -1) {
                oneByte[0] = (byte)data;
                outStr.write(oneByte);
                data = this.in.read();
                ++counter;
            }
            if (this.logger != null) {
                this.logger.info("[" + this.id + "] wrote " + counter + " bytes to the pipe");
                this.logger.info("[" + this.id + "] Connection from " + clientInfo + " closing");
            }
            this.socket.close();
        }
        catch (Exception e) {
            this.logger.error("[" + this.id + "] Connection from " + clientInfo + " got exception", e);
        }
        finally {
            if (outStr != null) {
                try {
                    outStr.close();
                }
                catch (IOException e) {
                    this.logger.error("[" + this.id + "] Failed to close output stream", e);
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.error("[" + this.id + "] Failed to close socket", e);
            }
        }
    }

    public OutputStream createOutputStream(String pipeName) throws Exception, SQLException {
        NamedPipeFactory factory = new NamedPipeFactory();
        PipeCallStrategy strategy = factory.getStrategy(this.logger);
        NamedPipeOutputStream os0 = strategy.beforeExecuteCreate(pipeName);
        if (os0 == null) {
            os0 = strategy.afterExecuteCreate(pipeName);
        }
        return os0;
    }
}

