/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import com.infobright.etl.model.BrighthouseRecord;
import com.infobright.etl.model.DataFormat;
import com.infobright.etl.model.datatype.AbstractColumnType;
import com.infobright.io.ClientProxy;
import com.infobright.io.IBVersionUtil;
import com.infobright.io.LoaderInstanceTracker;
import com.infobright.io.NamedPipeFactory;
import com.infobright.io.NamedPipeOutputStream;
import com.infobright.io.OSType;
import com.infobright.io.PipeCallStrategy;
import com.infobright.io.TeeOutputStream;
import com.infobright.logging.EtlLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;

public class InfobrightNamedPipeLoader {
    public static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    public static final int AGENT_DEFAULT_PORT = 5555;
    private static final String JDBC_MYSQL = "jdbc:mysql://";
    private static final String DEFAULT_PIPENAME_PREFIX = "bhnamedpipe";
    private static final int DEFAULT_TIMEOUT_SECONDS = 15;
    private String pipeNamePrefix = "bhnamedpipe";
    private String pipeName;
    private DataFormat dataFormat = DataFormat.TXT_VARIABLE;
    private int timeout = 15;
    private final Charset charset;
    private ExecutionThread executionThread;
    private final PipeCallStrategy strategy;
    private final EtlLogger logger;
    private final Connection connection;
    private final String tableName;
    private final String sql;
    private final NamedPipeFactory factory;
    private long id;
    private OutputStream os = null;
    private OutputStream debugOs = null;
    private boolean runStarted = false;
    private final ClientProxy proxy;
    private static boolean shuttingDown = false;

    public InfobrightNamedPipeLoader(String tableName, Connection connection, EtlLogger logger, DataFormat dataFormat, Charset charset) throws Exception {
        this(tableName, connection, logger, dataFormat, charset, 5555);
    }

    public InfobrightNamedPipeLoader(String tableName, Connection connection, EtlLogger logger, DataFormat dataFormat, Charset charset, int agentPort) throws Exception {
        boolean useLocalInfile;
        this.tableName = tableName;
        this.connection = connection;
        this.dataFormat = dataFormat;
        this.logger = logger;
        this.charset = charset;
        String hostName = InfobrightNamedPipeLoader._getHostName(connection);
        boolean isLocal = InfobrightNamedPipeLoader._isLocal(hostName);
        boolean bl = useLocalInfile = !isLocal && new OSType().isUnix() && new IBVersionUtil(connection).isSupportsLocalInfile();
        if (isLocal || useLocalInfile) {
            this.proxy = null;
            this.factory = new NamedPipeFactory();
        } else {
            this.proxy = new ClientProxy(hostName, agentPort);
            this.factory = new NamedPipeFactory(this.proxy);
        }
        this.strategy = this.factory.getStrategy(logger);
        this.id = LoaderInstanceTracker.register(this);
        this.pipeName = String.format("%s_%tH_%<tM_%<tS_%<tL-%d", this.pipeNamePrefix, new Date(), this.id);
        this.sql = dataFormat.getLoadSQL(this.getEscapedPipeName(this.pipeName), tableName, useLocalInfile);
    }

    private static String _getHostName(Connection connection2) throws SQLException {
        String url = connection2.getMetaData().getURL();
        if (!url.startsWith(JDBC_MYSQL)) {
            throw new RuntimeException("This does not look like a MySQL URL!");
        }
        String host = url.substring(JDBC_MYSQL.length());
        int index = host.indexOf(":");
        if (index == -1) {
            index = host.indexOf("/");
        }
        if (index == -1) {
            throw new RuntimeException("Can't extract hostname from JDBC URL (malformed?)");
        }
        host = host.substring(0, index);
        return host;
    }

    private static boolean _isLocal(String hostName) {
        return "localhost".equalsIgnoreCase(hostName) || "127.0.0.1".equals(hostName);
    }

    public InfobrightNamedPipeLoader(String tableName, Connection connection, EtlLogger logger, DataFormat dataFormat) throws Exception {
        this(tableName, connection, logger, dataFormat, DEFAULT_CHARSET);
    }

    private void startExecutionThread() throws Exception {
        if (InfobrightNamedPipeLoader.isShuttingDown()) {
            return;
        }
        assert (this.sql != null);
        this.executionThread = new ExecutionThread(this.connection, this.getDataFormat(), this.pipeName);
        this.executionThread.start();
        int maxWait = this.timeout * 1000;
        int sleepTime = 200;
        long startTime = System.currentTimeMillis();
        while (!this.executionThread.getConnecting() && this.executionThread.isAlive() && System.currentTimeMillis() - startTime < (long)maxWait) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception ex) {}
        }
        if (!this.executionThread.isAlive() || !this.executionThread.getConnecting()) {
            if (this.executionThread.ex != null) {
                throw this.executionThread.ex;
            }
            throw new Exception("BrightHouse background thread did not start as expected.");
        }
    }

    protected void joinExecutionThread() throws Exception {
        this.executionThread.join();
        if (this.executionThread.ex != null) {
            throw this.executionThread.ex;
        }
    }

    private DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    private String getEscapedPipeName(String pipeNm) {
        return this.factory.getNativePipeName(pipeNm).replace("\\", "\\\\");
    }

    public void setPipeNamePrefix(String pipeNamePrefix) {
        this.pipeNamePrefix = pipeNamePrefix;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public EtlLogger getEtlLogger() {
        return this.logger;
    }

    public void killQuery() throws SQLException {
        if (this.executionThread != null) {
            this.executionThread.killQuery();
        }
    }

    private Connection getConnection() {
        return this.connection;
    }

    private String getTableName() {
        return this.tableName;
    }

    public void finalize() {
        LoaderInstanceTracker.unregister(this);
    }

    long getID() {
        return this.id;
    }

    public NamedPipeOutputStream getOutputStream() throws IOException {
        if (this.os instanceof NamedPipeOutputStream) {
            return (NamedPipeOutputStream)this.os;
        }
        throw new UnsupportedOperationException("Running in debug mode. Please use getOutputStream2() instead of getOutputStream()");
    }

    public OutputStream getOutputStream2() {
        return this.os;
    }

    public void checkConnectionIsReady(int timeout) throws Exception {
    }

    public void setDebugOutputStream(OutputStream debugOs) {
        if (this.runStarted) {
            throw new IllegalStateException("must be called before start()");
        }
        this.debugOs = debugOs;
    }

    public void start() throws Exception, SQLException {
        this.runStarted = true;
        NamedPipeOutputStream os0 = this.strategy.beforeExecuteCreate(this.getPipeName());
        if (this.logger == null) {
            this.startExecutionThread();
        } else {
            long startTime = new Date().getTime();
            this.startExecutionThread();
            long timeToExec = new Date().getTime() - startTime;
            this.logger.debug("SQL load started in " + timeToExec + " ms");
        }
        if (os0 == null) {
            os0 = this.strategy.afterExecuteCreate(this.getPipeName());
        }
        this.os = this.debugOs == null ? os0 : new TeeOutputStream(os0, this.debugOs);
    }

    public void stop() throws Exception {
        if (this.os != null) {
            if (this.logger != null) {
                this.logger.debug("Loader closing output stream");
            }
            this.os.close();
        } else if (this.logger != null) {
            this.logger.debug("Loader: No output stream to close!");
        }
        if (this.logger != null) {
            this.logger.debug("Waiting for SQL load command to finish");
        }
        this.joinExecutionThread();
        if (this.logger != null) {
            this.logger.debug("SQL load finished");
        }
    }

    public BrighthouseRecord createRecord(boolean checkValues) throws SQLException {
        if (this.runStarted) {
            throw new IllegalStateException("Run is already started");
        }
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select * from `" + this.getTableName() + "` limit 0");
        ResultSetMetaData md = rs.getMetaData();
        List<AbstractColumnType> columns = BrighthouseRecord.readColumnTypes(md, this.charset, this.logger, checkValues);
        rs.close();
        stmt.close();
        return this.getDataFormat().createRecord(columns, this.charset, this.logger);
    }

    static synchronized void setShuttingDown() {
        shuttingDown = true;
    }

    static synchronized boolean isShuttingDown() {
        return shuttingDown;
    }

    class ExecutionThread
    extends Thread {
        private final Connection connection;
        private final DataFormat dataFormat;
        private final String pipeName;
        private Statement statement;
        boolean connecting = false;
        Exception ex = null;
        private boolean alreadyKilled = false;

        ExecutionThread(Connection connection, DataFormat dataFormat, String pipeName) {
            this.connection = connection;
            this.dataFormat = dataFormat;
            this.pipeName = pipeName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.statement = this.connection.createStatement();
                String setupSql = "set @bh_dataformat='" + this.dataFormat.getBhDataFormat() + "';";
                if (InfobrightNamedPipeLoader.this.logger != null) {
                    InfobrightNamedPipeLoader.this.logger.debug(String.format("exec sql: %s", setupSql));
                }
                this.statement.execute(setupSql);
                InfobrightNamedPipeLoader.this.strategy.setupForLoad(this.statement, new Integer[]{InfobrightNamedPipeLoader.this.timeout});
                if (InfobrightNamedPipeLoader.this.logger != null) {
                    InfobrightNamedPipeLoader.this.logger.debug(String.format("ID#%d starting %s load thread via named pipe %s", new Object[]{InfobrightNamedPipeLoader.this.getID(), this.dataFormat, this.pipeName}));
                }
                this.connecting = true;
                if (InfobrightNamedPipeLoader.this.logger != null) {
                    InfobrightNamedPipeLoader.this.logger.debug(String.format("ID#%d executing sql: %s", InfobrightNamedPipeLoader.this.getID(), InfobrightNamedPipeLoader.this.sql));
                }
                try {
                    this.statement.execute(InfobrightNamedPipeLoader.this.sql);
                }
                finally {
                    if (InfobrightNamedPipeLoader.this.proxy != null) {
                        InfobrightNamedPipeLoader.this.proxy.disconnect();
                    }
                }
                if (InfobrightNamedPipeLoader.this.logger != null) {
                    InfobrightNamedPipeLoader.this.logger.debug(String.format("load thread via named pipe %s stopped", this.pipeName));
                }
            }
            catch (Exception se) {
                if (InfobrightNamedPipeLoader.this.logger != null) {
                    InfobrightNamedPipeLoader.this.logger.error("Exception during sql named pipe use", se);
                }
                this.ex = se;
            }
            catch (UnsatisfiedLinkError error) {
                this.ex = new Exception(error.getMessage() + ", java.library.path=" + System.getProperty("java.library.path"), error);
            }
            finally {
                this.connecting = false;
            }
        }

        boolean getConnecting() {
            return this.connecting;
        }

        synchronized void killQuery() throws SQLException {
            if (!this.alreadyKilled && this.statement != null) {
                this.statement.cancel();
                if (InfobrightNamedPipeLoader.this.logger != null) {
                    InfobrightNamedPipeLoader.this.logger.debug(String.format("ID#%d SQL statement cancelled", InfobrightNamedPipeLoader.this.getID()));
                }
                this.alreadyKilled = true;
            }
        }
    }
}

