/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.logging;

import com.infobright.logging.EtlLogger;
import java.util.Date;

public class ConsoleEtlLogger
implements EtlLogger {
    private final Level level;

    public ConsoleEtlLogger(Level level) {
        this.level = level;
    }

    private void print(String sLevel, String message) {
        System.out.println(sLevel + ": " + new Date() + ": " + message);
    }

    public void debug(String s) {
        if (this.level.doLog(Level.DEBUG)) {
            this.print("DEBUG", s);
        }
    }

    public void error(String s, Throwable cause) {
        if (this.level.doLog(Level.ERROR)) {
            this.error(s);
            cause.printStackTrace();
        }
    }

    public void fatal(String s) {
        if (this.level.doLog(Level.FATAL)) {
            this.print("FATAL", s);
        }
    }

    public void error(String s) {
        if (this.level.doLog(Level.ERROR)) {
            this.print("ERROR", s);
        }
    }

    public void info(String s) {
        if (this.level.doLog(Level.INFO)) {
            this.print("INFO", s);
        }
    }

    public void trace(String s) {
        if (this.level.doLog(Level.TRACE)) {
            this.print("TRACE", s);
        }
    }

    public void warn(String s) {
        if (this.level.doLog(Level.WARN)) {
            this.print("WARN", s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        ALL(-1),
        TRACE(0),
        DEBUG(1),
        INFO(2),
        WARN(3),
        ERROR(4),
        FATAL(5),
        OFF(6);

        private final int iLevel;

        private Level(int iLevel) {
            this.iLevel = iLevel;
        }

        private boolean doLog(Level level) {
            return this.iLevel <= level.iLevel;
        }
    }
}

