/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.NMQ_N01_NCKNSTNSC;
import ca.uhn.hl7v2.model.v231.group.NMQ_N01_QRDQRF;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class NMQ_N01
extends AbstractMessage {
    public NMQ_N01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public NMQ_N01() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NMQ_N01_QRDQRF.class, false, false);
            this.add(NMQ_N01_NCKNSTNSC.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating NMQ_N01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMQ_N01_QRDQRF getQRDQRF() {
        NMQ_N01_QRDQRF ret = null;
        try {
            ret = (NMQ_N01_QRDQRF)this.get("QRDQRF");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMQ_N01_NCKNSTNSC getNCKNSTNSC() {
        NMQ_N01_NCKNSTNSC ret = null;
        try {
            ret = (NMQ_N01_NCKNSTNSC)this.get("NCKNSTNSC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMQ_N01_NCKNSTNSC getNCKNSTNSC(int rep) {
        NMQ_N01_NCKNSTNSC ret = null;
        try {
            ret = (NMQ_N01_NCKNSTNSC)this.get("NCKNSTNSC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNCKNSTNSCReps() {
        int reps = -1;
        try {
            reps = this.getAll("NCKNSTNSC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNCKNSTNSC(NMQ_N01_NCKNSTNSC structure, int rep) throws HL7Exception {
        super.insertRepetition("NCKNSTNSC", (Structure)structure, rep);
    }

    public NMQ_N01_NCKNSTNSC insertNCKNSTNSC(int rep) throws HL7Exception {
        return (NMQ_N01_NCKNSTNSC)super.insertRepetition("NCKNSTNSC", rep);
    }

    public NMQ_N01_NCKNSTNSC removeNCKNSTNSC(int rep) throws HL7Exception {
        return (NMQ_N01_NCKNSTNSC)super.removeRepetition("NCKNSTNSC", rep);
    }
}

