/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI;
import ca.uhn.hl7v2.model.v231.group.RAS_O01_PIDPD1NTEAL1PV1PV2;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RAS_O01
extends AbstractMessage {
    public RAS_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public RAS_O01() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(RAS_O01_PIDPD1NTEAL1PV1PV2.class, false, false);
            this.add(RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating RAS_O01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RAS_O01_PIDPD1NTEAL1PV1PV2 getPIDPD1NTEAL1PV1PV2() {
        RAS_O01_PIDPD1NTEAL1PV1PV2 ret = null;
        try {
            ret = (RAS_O01_PIDPD1NTEAL1PV1PV2)this.get("PIDPD1NTEAL1PV1PV2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI getORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI() {
        RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI ret = null;
        try {
            ret = (RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI)this.get("ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI getORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI(int rep) {
        RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI ret = null;
        try {
            ret = (RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI)this.get("ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI(RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI", (Structure)structure, rep);
    }

    public RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI insertORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI(int rep) throws HL7Exception {
        return (RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI)super.insertRepetition("ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI", rep);
    }

    public RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI removeORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI(int rep) throws HL7Exception {
        return (RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI)super.removeRepetition("ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI", rep);
    }
}

