/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.util.Pair;

public class CombinerPackager
extends Packager {
    private static final long serialVersionUID = 1L;
    private boolean[] mBags;
    private Map<Integer, Integer> keyLookup;
    private int numBags;
    private transient boolean initialized;
    private transient boolean useDefaultBag;

    public CombinerPackager(Packager pkg, boolean[] bags) {
        int i;
        this.keyType = pkg.keyType;
        this.numInputs = 1;
        this.inner = new boolean[pkg.inner.length];
        for (i = 0; i < pkg.inner.length; ++i) {
            this.inner[i] = true;
        }
        if (bags != null) {
            this.mBags = Arrays.copyOf(bags, bags.length);
        }
        this.numBags = 0;
        for (i = 0; i < this.mBags.length; ++i) {
            if (!this.mBags[i]) continue;
            ++this.numBags;
        }
    }

    @Override
    public void attachInput(Object key, DataBag[] bags, boolean[] readOnce) throws ExecException {
        this.key = key;
        this.bags = bags;
        this.readOnce = readOnce;
    }

    @Override
    public void setKeyInfo(Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo) {
        this.keyInfo = keyInfo;
        Pair<Boolean, Map<Integer, Integer>> lrKeyInfo = keyInfo.get(0);
        this.keyLookup = (Map)lrKeyInfo.second;
    }

    private DataBag createDataBag(int numBags) {
        if (!this.initialized) {
            String bagType;
            this.initialized = true;
            if (PigMapReduce.sJobConfInternal.get() != null && (bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.type")) != null && bagType.equalsIgnoreCase("default")) {
                this.useDefaultBag = true;
            }
        }
        return this.useDefaultBag ? new NonSpillableDataBag() : new InternalCachedBag(numBags);
    }

    @Override
    public Result getNext() throws ExecException {
        if (this.bags == null) {
            return new Result(3, null);
        }
        Object[] fields = new Object[this.mBags.length];
        for (int i = 0; i < this.mBags.length; ++i) {
            if (!this.mBags[i]) continue;
            fields[i] = this.createDataBag(this.numBags);
        }
        for (Tuple tup : this.bags[0]) {
            int tupIndex = 0;
            for (int i = 0; i < this.mBags.length; ++i) {
                Integer keyIndex = this.keyLookup.get(i);
                if (keyIndex == null && this.mBags[i]) {
                    ((DataBag)fields[i]).add((Tuple)tup.get(tupIndex));
                    ++tupIndex;
                    continue;
                }
                fields[i] = this.key;
            }
        }
        this.detachInput();
        Tuple res = mTupleFactory.newTuple(this.mBags.length);
        for (int i = 0; i < this.mBags.length; ++i) {
            res.set(i, fields[i]);
        }
        Result r = new Result();
        r.result = res;
        r.returnStatus = 0;
        return r;
    }

    @Override
    public Tuple getValueTuple(PigNullableWritable keyWritable, NullableTuple ntup, int index) throws ExecException {
        return (Tuple)ntup.getValueAsPigType();
    }
}

