/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;

public class SparkEngineConf
implements Serializable {
    private static final Log LOG = LogFactory.getLog(SparkEngineConf.class);
    private static String SPARK_UDF_IMPORT_LIST = "pig.spark.udf.import.list";
    private static String SPARK_UDFCONTEXT_UDFCONFS = "pig.spark.udfcontext.udfConfs";
    private static String SPARK_UDFCONTEXT_CLIENTSYSPROPS = "pig.spark.udfcontext.clientSysProps";
    private Properties properties = new Properties();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ArrayList udfImportList = (ArrayList)in.readObject();
        PigContext.setPackageImportList(udfImportList);
        String udfConfsStr = (String)in.readObject();
        String clientSysPropsStr = (String)in.readObject();
        UDFContext.getUDFContext().deserializeForSpark(udfConfsStr, clientSysPropsStr);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ArrayList udfImportList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)this.properties.getProperty(SPARK_UDF_IMPORT_LIST)));
        out.writeObject(udfImportList);
        if (!UDFContext.getUDFContext().isUDFConfEmpty()) {
            String udfConfsStr = UDFContext.getUDFContext().serialize();
            String clientSysPropsStr = ObjectSerializer.serialize(UDFContext.getUDFContext().getClientSystemProps());
            this.properties.setProperty(SPARK_UDFCONTEXT_UDFCONFS, udfConfsStr);
            this.properties.setProperty(SPARK_UDFCONTEXT_CLIENTSYSPROPS, clientSysPropsStr);
            out.writeObject(udfConfsStr);
            out.writeObject(clientSysPropsStr);
        } else {
            out.writeObject(this.properties.getProperty(SPARK_UDFCONTEXT_UDFCONFS));
            out.writeObject(this.properties.getProperty(SPARK_UDFCONTEXT_CLIENTSYSPROPS));
        }
    }

    public void setSparkUdfImportListStr(String sparkUdfImportListStr) {
        this.properties.setProperty(SPARK_UDF_IMPORT_LIST, sparkUdfImportListStr);
    }
}

