/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.plan;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

public class SparkOperator
extends Operator<SparkOpPlanVisitor> {
    public PhysicalPlan physicalPlan;
    public Set<String> UDFs;
    public String customPartitioner = null;
    public Set<PhysicalOperator> scalars;
    public int requestedParallelism = -1;
    private BitSet feature = new BitSet();
    private boolean splitter = false;
    private String skewedJoinPartitionFile;
    private boolean usingTypedComparator = false;
    private boolean combineSmallSplits = true;
    private List<String> crossKeys = null;
    private MultiMap<OperatorKey, OperatorKey> multiQueryOptimizeConnectionMap = new MultiMap();
    boolean isUDFComparatorUsed = false;
    private String quantFile;
    private boolean globalSort = false;

    public SparkOperator(OperatorKey k) {
        super(k);
        this.physicalPlan = new PhysicalPlan();
        this.UDFs = new HashSet<String>();
        this.scalars = new HashSet<PhysicalOperator>();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    @Override
    public String name() {
        String udfStr = this.getUDFsAsStr();
        StringBuilder sb = new StringBuilder("Spark(" + this.requestedParallelism + (udfStr.equals("") ? "" : ",") + udfStr + ")" + " - " + this.mKey.toString());
        return sb.toString();
    }

    private String getUDFsAsStr() {
        StringBuilder sb = new StringBuilder();
        if (this.UDFs != null && this.UDFs.size() > 0) {
            for (String str : this.UDFs) {
                sb.append(str.substring(str.lastIndexOf(46) + 1));
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void add(PhysicalOperator physicalOper) {
        this.physicalPlan.add(physicalOper);
    }

    @Override
    public void visit(SparkOpPlanVisitor v) throws VisitorException {
        v.visitSparkOp(this);
    }

    public void addCrossKey(String key) {
        if (this.crossKeys == null) {
            this.crossKeys = new ArrayList<String>();
        }
        this.crossKeys.add(key);
    }

    public List<String> getCrossKeys() {
        return this.crossKeys;
    }

    public boolean isGroupBy() {
        return this.feature.get(OPER_FEATURE.GROUPBY.ordinal());
    }

    public void markGroupBy() {
        this.feature.set(OPER_FEATURE.GROUPBY.ordinal());
    }

    public boolean isCogroup() {
        return this.feature.get(OPER_FEATURE.COGROUP.ordinal());
    }

    public void markCogroup() {
        this.feature.set(OPER_FEATURE.COGROUP.ordinal());
    }

    public boolean isRegularJoin() {
        return this.feature.get(OPER_FEATURE.HASHJOIN.ordinal());
    }

    public void markRegularJoin() {
        this.feature.set(OPER_FEATURE.HASHJOIN.ordinal());
    }

    public int getRequestedParallelism() {
        return this.requestedParallelism;
    }

    public void setSplitter(boolean spl) {
        this.splitter = spl;
    }

    public boolean isSplitter() {
        return this.splitter;
    }

    public boolean isSampler() {
        return this.feature.get(OPER_FEATURE.SAMPLER.ordinal());
    }

    public void markSampler() {
        this.feature.set(OPER_FEATURE.SAMPLER.ordinal());
    }

    public void setSkewedJoinPartitionFile(String file) {
        this.skewedJoinPartitionFile = file;
    }

    public String getSkewedJoinPartitionFile() {
        return this.skewedJoinPartitionFile;
    }

    protected boolean usingTypedComparator() {
        return this.usingTypedComparator;
    }

    protected void useTypedComparator(boolean useTypedComparator) {
        this.usingTypedComparator = useTypedComparator;
    }

    protected void noCombineSmallSplits() {
        this.combineSmallSplits = false;
    }

    public boolean combineSmallSplits() {
        return this.combineSmallSplits;
    }

    public boolean isIndexer() {
        return this.feature.get(OPER_FEATURE.INDEXER.ordinal());
    }

    public void markIndexer() {
        this.feature.set(OPER_FEATURE.INDEXER.ordinal());
    }

    public boolean isUnion() {
        return this.feature.get(OPER_FEATURE.UNION.ordinal());
    }

    public void markUnion() {
        this.feature.set(OPER_FEATURE.UNION.ordinal());
    }

    public boolean isNative() {
        return this.feature.get(OPER_FEATURE.NATIVE.ordinal());
    }

    public void markNative() {
        this.feature.set(OPER_FEATURE.NATIVE.ordinal());
    }

    public boolean isLimit() {
        return this.feature.get(OPER_FEATURE.LIMIT.ordinal());
    }

    public void markLimit() {
        this.feature.set(OPER_FEATURE.LIMIT.ordinal());
    }

    public boolean isLimitAfterSort() {
        return this.feature.get(OPER_FEATURE.LIMIT_AFTER_SORT.ordinal());
    }

    public void markLimitAfterSort() {
        this.feature.set(OPER_FEATURE.LIMIT_AFTER_SORT.ordinal());
    }

    public void copyFeatures(SparkOperator copyFrom, List<OPER_FEATURE> excludeFeatures) {
        for (OPER_FEATURE opf : OPER_FEATURE.values()) {
            if (excludeFeatures != null && excludeFeatures.contains((Object)opf) || !copyFrom.feature.get(opf.ordinal())) continue;
            this.feature.set(opf.ordinal());
        }
    }

    public boolean isSkewedJoin() {
        return this.skewedJoinPartitionFile != null;
    }

    public void setRequestedParallelism(int requestedParallelism) {
        this.requestedParallelism = requestedParallelism;
    }

    public void setRequestedParallelismByReference(SparkOperator oper) {
        this.requestedParallelism = oper.requestedParallelism;
    }

    public void addMultiQueryOptimizeConnectionItem(OperatorKey to, OperatorKey from) {
        this.multiQueryOptimizeConnectionMap.put(to, from);
    }

    public MultiMap<OperatorKey, OperatorKey> getMultiQueryOptimizeConnectionItem() {
        return this.multiQueryOptimizeConnectionMap;
    }

    public void setGlobalSort(boolean globalSort) {
        this.globalSort = globalSort;
    }

    public boolean isGlobalSort() {
        return this.globalSort;
    }

    private static enum OPER_FEATURE {
        NONE,
        SAMPLER,
        INDEXER,
        GROUPBY,
        COGROUP,
        HASHJOIN,
        UNION,
        NATIVE,
        LIMIT,
        LIMIT_AFTER_SORT;

    }
}

