/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import dk.brics.automaton.Automaton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.antlr.runtime.CommonTokenStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.impl.PigContext;
import org.apache.tools.bzip2r.BZip2Constants;
import org.joda.time.DateTime;

public class JarManager {
    private static Log log = LogFactory.getLog(JarManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createPigScriptUDFJar(PigContext pigContext) throws IOException {
        File scriptUDFJarFile = File.createTempFile("PigScriptUDF", ".jar");
        scriptUDFJarFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(scriptUDFJarFile);
        HashMap<String, String> contents = new HashMap<String, String>();
        JarManager.createPigScriptUDFJar(fos, pigContext, contents);
        if (!contents.isEmpty()) {
            String md5 = null;
            try (FileInputStream fis = null;){
                fis = new FileInputStream(scriptUDFJarFile);
                md5 = DigestUtils.md5Hex((InputStream)fis);
            }
            File newScriptUDFJarFile = new File(scriptUDFJarFile.getParent(), "PigScriptUDF-" + md5 + ".jar");
            scriptUDFJarFile.renameTo(newScriptUDFJarFile);
            return newScriptUDFJarFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createPigScriptUDFJar(OutputStream os, PigContext pigContext, HashMap<String, String> contents) throws IOException {
        InputStream stream;
        JarOutputStream jarOutputStream = new JarOutputStream(os);
        for (String string : pigContext.scriptFiles) {
            log.debug((Object)("Adding entry " + string + " to job jar"));
            stream = null;
            File inputFile = new File(string);
            stream = inputFile.exists() ? new FileInputStream(inputFile) : PigContext.getClassLoader().getResourceAsStream(string);
            if (stream == null) {
                throw new IOException("Cannot find " + string);
            }
            try {
                JarManager.addStream(jarOutputStream, string, stream, contents, inputFile.lastModified());
            }
            finally {
                stream.close();
            }
        }
        for (Map.Entry entry : pigContext.getScriptFiles().entrySet()) {
            log.debug((Object)("Adding entry " + (String)entry.getKey() + " to job jar"));
            stream = null;
            stream = ((File)entry.getValue()).exists() ? new FileInputStream((File)entry.getValue()) : PigContext.getClassLoader().getResourceAsStream(((File)entry.getValue()).getPath());
            if (stream == null) {
                throw new IOException("Cannot find " + ((File)entry.getValue()).getPath());
            }
            try {
                JarManager.addStream(jarOutputStream, (String)entry.getKey(), stream, contents, ((File)entry.getValue()).lastModified());
            }
            finally {
                stream.close();
            }
        }
        if (!contents.isEmpty()) {
            jarOutputStream.close();
        } else {
            os.close();
        }
    }

    static ClassLoader createCl(String jarFile, PigContext pigContext) throws MalformedURLException {
        int len = pigContext.extraJars.size();
        int passedJar = jarFile == null ? 0 : 1;
        URL[] urls = new URL[len + passedJar];
        if (jarFile != null) {
            urls[0] = new URL("file:" + jarFile);
        }
        for (int i = 0; i < pigContext.extraJars.size(); ++i) {
            urls[i + passedJar] = new URL("file:" + pigContext.extraJars.get(i));
        }
        return new URLClassLoader(urls, PigMapReduce.class.getClassLoader());
    }

    private static void addStream(JarOutputStream os, String name, InputStream is, Map<String, String> contents, long timestamp) throws IOException {
        int rc;
        if (contents.get(name) != null) {
            return;
        }
        contents.put(name, "");
        JarEntry entry = new JarEntry(name);
        entry.setTime(timestamp);
        os.putNextEntry(entry);
        byte[] buffer = new byte[4096];
        while ((rc = is.read(buffer)) > 0) {
            os.write(buffer, 0, rc);
        }
    }

    public static List<String> getDefaultJars() {
        ArrayList<String> defaultJars = new ArrayList<String>();
        for (DefaultPigPackages pkgToSend : DefaultPigPackages.values()) {
            String jar = JarManager.findContainingJar(pkgToSend.getPkgClass());
            if (jar == null || defaultJars.contains(jar)) continue;
            defaultJars.add(jar);
        }
        return defaultJars;
    }

    public static String findContainingJar(Class my_class) {
        ClassLoader loader = PigContext.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = null;
            if (loader instanceof URLClassLoader) {
                itr = ((URLClassLoader)loader).findResources(class_file);
            }
            if (itr == null || !itr.hasMoreElements()) {
                itr = loader.getResources(class_file);
            }
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void addDependencyJars(Job job, Class<?> ... classes) throws IOException {
        Configuration conf = job.getConfiguration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        JarManager.addQualifiedJarsName((FileSystem)fs, jars, classes);
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[0])));
    }

    private static void addQualifiedJarsName(FileSystem fs, Set<String> jars, Class<?> ... classes) {
        URI fsUri = fs.getUri();
        Path workingDir = fs.getWorkingDirectory();
        for (Class<?> clazz : classes) {
            String jarName = JarManager.findContainingJar(clazz);
            if (jarName == null) {
                log.warn((Object)("Could not find jar for class " + clazz));
                continue;
            }
            jars.add(new Path(jarName).makeQualified(fsUri, workingDir).toString());
        }
    }

    private static enum DefaultPigPackages {
        PIG(PigMapReduce.class),
        BZIP2R(BZip2Constants.class),
        AUTOMATON(Automaton.class),
        ANTLR(CommonTokenStream.class),
        JODATIME(DateTime.class);

        private final Class pkgClass;

        private DefaultPigPackages(Class pkgClass) {
            this.pkgClass = pkgClass;
        }

        public Class getPkgClass() {
            return this.pkgClass;
        }
    }
}

