/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;

public class ScalarVariableValidator
extends LogicalRelationalNodesVisitor {
    public static final String ERR_MSG_SCALAR = "Expression in Limit/Sample should be scalar";

    public ScalarVariableValidator(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    @Override
    public void visit(LOLimit limit) throws FrontendException {
        LogicalExpressionPlan expression = limit.getLimitPlan();
        if (expression != null) {
            ProjectFinder pf = new ProjectFinder(expression, new ReverseDependencyOrderWalker(expression));
            pf.visit();
            if (pf.found()) {
                int errCode = 1131;
                throw new VisitorException((Operator)limit, ERR_MSG_SCALAR, errCode, 2);
            }
        }
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
        LogicalExpressionPlan expression = filter.getFilterPlan();
        if (expression != null && filter.isSample()) {
            ProjectFinder pf = new ProjectFinder(expression, new ReverseDependencyOrderWalker(expression));
            pf.visit();
            if (pf.found()) {
                int errCode = 1131;
                throw new VisitorException((Operator)filter, ERR_MSG_SCALAR, errCode, 2);
            }
        }
    }

    public static class ProjectFinder
    extends LogicalExpressionVisitor {
        private boolean foundProject;

        public boolean found() {
            return this.foundProject;
        }

        protected ProjectFinder(OperatorPlan p, PlanWalker walker) throws FrontendException {
            super(p, walker);
        }

        @Override
        public void visit(ProjectExpression project) {
            this.foundProject = true;
        }
    }
}

