/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import mondrian.spi.CatalogLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class LegacyCatalogLocator
implements CatalogLocator {
    private static final Log logger = LogFactory.getLog(LegacyCatalogLocator.class);
    private Properties mapping = this.load();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties load() {
        URL resource = this.getClass().getResource("/mondrian-schema-mapping.properties");
        if (resource == null) {
            logger.debug((Object)"Unable to locate properties at '/mondrian-schema-mapping.properties'");
            return new Properties();
        }
        Properties p = new Properties();
        try (InputStream inStream = resource.openStream();){
            p.load(inStream);
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to parse mapping", (Throwable)e);
        }
        return p;
    }

    public String locate(String s) {
        String fileName = IOUtils.getInstance().getFileName(s);
        String mapped = this.mapping.getProperty(fileName);
        if (StringUtils.isEmpty((String)mapped)) {
            return null;
        }
        return mapped;
    }
}

