/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BulkResponseInfo;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.client.rest.BulkResponseImpl;
import org.apache.oozie.client.rest.JsonTags;
import org.apache.oozie.service.BundleEngineService;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.BaseJobsServlet;
import org.apache.oozie.servlet.ServletUtilities;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class V1JobsServlet
extends BaseJobsServlet {
    private static final String INSTRUMENTATION_NAME = "v1jobs";
    private static final Set<String> httpJobType = new HashSet<String>(){
        {
            this.add("hive");
            this.add("sqoop");
            this.add("pig");
            this.add("mapreduce");
        }
    };

    public V1JobsServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected JSONObject submitJob(HttpServletRequest request, Configuration conf) throws XServletException, IOException {
        JSONObject json = null;
        String jobType = request.getParameter("jobtype");
        if (jobType == null) {
            String wfPath = conf.get("oozie.wf.application.path");
            String coordPath = conf.get("oozie.coord.application.path");
            String bundlePath = conf.get("oozie.bundle.application.path");
            ServletUtilities.ValidateAppPath(wfPath, coordPath, bundlePath);
            json = wfPath != null ? this.submitWorkflowJob(request, conf) : (coordPath != null ? this.submitCoordinatorJob(request, conf) : this.submitBundleJob(request, conf));
        } else if (httpJobType.contains(jobType)) {
            json = this.submitHttpJob(request, conf, jobType);
        } else {
            throw new XServletException(400, ErrorCode.E0303, "jobtype", jobType);
        }
        return json;
    }

    @Override
    protected JSONObject getJobIdForExternalId(HttpServletRequest request, String externalId) throws XServletException, IOException {
        JSONObject json = null;
        String jobtype = request.getParameter("jobtype");
        jobtype = jobtype != null ? jobtype : "wf";
        json = jobtype.contains("wf") ? this.getWorkflowJobIdForExternalId(request, externalId) : this.getCoordinatorJobIdForExternalId(request, externalId);
        return json;
    }

    @Override
    protected JSONObject getJobs(HttpServletRequest request) throws XServletException, IOException {
        JSONObject json = null;
        String isBulk = request.getParameter("bulk");
        if (isBulk != null) {
            json = this.getBulkJobs(request);
        } else {
            String jobtype = request.getParameter("jobtype");
            String string = jobtype = jobtype != null ? jobtype : "wf";
            if (jobtype.contains("wf")) {
                json = this.getWorkflowJobs(request);
            } else if (jobtype.contains("coord")) {
                json = this.getCoordinatorJobs(request);
            } else if (jobtype.contains("bundle")) {
                json = this.getBundleJobs(request);
            }
        }
        return json;
    }

    private JSONObject submitWorkflowJob(HttpServletRequest request, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String action = request.getParameter("action");
            if (action != null && !action.equals("start") && !action.equals("dryrun")) {
                throw new XServletException(400, ErrorCode.E0303, "action", action);
            }
            boolean startJob = action != null;
            String user = conf.get("user.name");
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(user);
            boolean dryrun = false;
            if (action != null) {
                dryrun = action.equals("dryrun");
            }
            String id = dryrun ? dagEngine.dryRunSubmit(conf) : dagEngine.submitJob(conf, startJob);
            json.put((Object)"id", (Object)id);
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject submitCoordinatorJob(HttpServletRequest request, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        XLog.getLog(((Object)((Object)this)).getClass()).warn("submitCoordinatorJob " + XmlUtils.prettyPrint(conf).toString());
        try {
            String action = request.getParameter("action");
            if (action != null && !action.equals("start") && !action.equals("dryrun")) {
                throw new XServletException(400, ErrorCode.E0303, "action", action);
            }
            boolean startJob = action != null;
            String user = conf.get("user.name");
            CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(user);
            String id = null;
            boolean dryrun = false;
            if (action != null) {
                dryrun = action.equals("dryrun");
            }
            id = dryrun ? coordEngine.dryRunSubmit(conf) : coordEngine.submitJob(conf, startJob);
            json.put((Object)"id", (Object)id);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject submitBundleJob(HttpServletRequest request, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        XLog.getLog(((Object)((Object)this)).getClass()).warn("submitBundleJob " + XmlUtils.prettyPrint(conf).toString());
        try {
            String action = request.getParameter("action");
            if (action != null && !action.equals("start") && !action.equals("dryrun")) {
                throw new XServletException(400, ErrorCode.E0303, "action", action);
            }
            boolean startJob = action != null;
            String user = conf.get("user.name");
            BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(user);
            String id = null;
            boolean dryrun = false;
            if (action != null) {
                dryrun = action.equals("dryrun");
            }
            id = dryrun ? bundleEngine.dryRunSubmit(conf) : bundleEngine.submitJob(conf, startJob);
            json.put((Object)"id", (Object)id);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getWorkflowJobIdForExternalId(HttpServletRequest request, String externalId) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
            String jobId = dagEngine.getJobIdForExternalId(externalId);
            json.put((Object)"id", (Object)jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getCoordinatorJobIdForExternalId(HttpServletRequest request, String externalId) throws XServletException {
        JSONObject json = new JSONObject();
        return json;
    }

    private JSONObject getWorkflowJobs(HttpServletRequest request) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String filter = request.getParameter("filter");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            String timeZoneId = request.getParameter("timezone") == null ? "GMT" : request.getParameter("timezone");
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
            WorkflowsInfo jobs = dagEngine.getJobs(filter, start, len);
            List<WorkflowJobBean> jsonWorkflows = jobs.getWorkflows();
            json.put((Object)"workflows", (Object)WorkflowJobBean.toJSONArray(jsonWorkflows, timeZoneId));
            json.put((Object)"total", (Object)jobs.getTotal());
            json.put((Object)"offset", (Object)jobs.getStart());
            json.put((Object)"len", (Object)jobs.getLen());
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getCoordinatorJobs(HttpServletRequest request) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String filter = request.getParameter("filter");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            String timeZoneId = request.getParameter("timezone") == null ? "GMT" : request.getParameter("timezone");
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
            CoordinatorJobInfo jobs = coordEngine.getCoordJobs(filter, start, len);
            List<CoordinatorJobBean> jsonJobs = jobs.getCoordJobs();
            json.put(JsonTags.COORDINATOR_JOBS, (Object)CoordinatorJobBean.toJSONArray(jsonJobs, timeZoneId));
            json.put(JsonTags.COORD_JOB_TOTAL, (Object)jobs.getTotal());
            json.put(JsonTags.COORD_JOB_OFFSET, (Object)jobs.getStart());
            json.put(JsonTags.COORD_JOB_LEN, (Object)jobs.getLen());
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getBundleJobs(HttpServletRequest request) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String filter = request.getParameter("filter");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            String timeZoneId = request.getParameter("timezone") == null ? "GMT" : request.getParameter("timezone");
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
            BundleJobInfo jobs = bundleEngine.getBundleJobs(filter, start, len);
            List<BundleJobBean> jsonJobs = jobs.getBundleJobs();
            json.put(JsonTags.BUNDLE_JOBS, (Object)BundleJobBean.toJSONArray(jsonJobs, timeZoneId));
            json.put(JsonTags.BUNDLE_JOB_TOTAL, (Object)jobs.getTotal());
            json.put(JsonTags.BUNDLE_JOB_OFFSET, (Object)jobs.getStart());
            json.put(JsonTags.BUNDLE_JOB_LEN, (Object)jobs.getLen());
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getBulkJobs(HttpServletRequest request) throws XServletException, IOException {
        JSONObject json = new JSONObject();
        try {
            String bulkFilter = request.getParameter("bulk");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            String timeZoneId = request.getParameter("timezone") == null ? "GMT" : request.getParameter("timezone");
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
            BulkResponseInfo bulkResponse = bundleEngine.getBulkJobs(bulkFilter, start, len);
            List<BulkResponseImpl> responsesToJson = bulkResponse.getResponses();
            json.put(JsonTags.BULK_RESPONSES, (Object)BulkResponseImpl.toJSONArray(responsesToJson, timeZoneId));
            json.put(JsonTags.BULK_RESPONSE_TOTAL, (Object)bulkResponse.getTotal());
            json.put(JsonTags.BULK_RESPONSE_OFFSET, (Object)bulkResponse.getStart());
            json.put(JsonTags.BULK_RESPONSE_LEN, (Object)bulkResponse.getLen());
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject submitHttpJob(HttpServletRequest request, Configuration conf, String jobType) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String user = conf.get("user.name");
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(user);
            String id = dagEngine.submitHttpJob(conf, jobType);
            json.put((Object)"id", (Object)id);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    @Override
    protected JSONObject killJobs(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        return this.bulkModifyJobs(request, response);
    }

    @Override
    protected JSONObject suspendJobs(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        return this.bulkModifyJobs(request, response);
    }

    @Override
    protected JSONObject resumeJobs(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        return this.bulkModifyJobs(request, response);
    }

    private JSONObject bulkModifyJobs(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String action = request.getParameter("action");
        String jobType = request.getParameter("jobtype");
        String filter = request.getParameter("filter");
        String startStr = request.getParameter("offset");
        String lenStr = request.getParameter("len");
        String timeZoneId = request.getParameter("timezone") == null ? "GMT" : request.getParameter("timezone");
        int start = startStr != null ? Integer.parseInt(startStr) : 1;
        start = start < 1 ? 1 : start;
        int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
        len = len < 1 ? 50 : len;
        JSONObject json = new JSONObject();
        ArrayList<String> ids = new ArrayList<String>();
        if (jobType.equals("wf")) {
            WorkflowsInfo jobs = null;
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
            if (action.equals("kill")) {
                try {
                    jobs = dagEngine.killJobs(filter, start, len);
                }
                catch (DagEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            if (action.equals("suspend")) {
                try {
                    jobs = dagEngine.suspendJobs(filter, start, len);
                }
                catch (DagEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            if (action.equals("resume")) {
                try {
                    jobs = dagEngine.resumeJobs(filter, start, len);
                }
                catch (DagEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            json.put((Object)"workflows", (Object)WorkflowJobBean.toJSONArray(jobs.getWorkflows(), timeZoneId));
            json.put((Object)"total", (Object)jobs.getTotal());
            json.put((Object)"offset", (Object)jobs.getStart());
            json.put((Object)"len", (Object)jobs.getLen());
        } else if (jobType.equals("bundle")) {
            BundleJobInfo jobs = null;
            BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
            if (action.equals("kill")) {
                try {
                    jobs = bundleEngine.killJobs(filter, start, len);
                }
                catch (BundleEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            if (action.equals("suspend")) {
                try {
                    jobs = bundleEngine.suspendJobs(filter, start, len);
                }
                catch (BundleEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            if (action.equals("resume")) {
                try {
                    jobs = bundleEngine.resumeJobs(filter, start, len);
                }
                catch (BundleEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            json.put(JsonTags.BUNDLE_JOBS, (Object)BundleJobBean.toJSONArray(jobs.getBundleJobs(), timeZoneId));
            json.put(JsonTags.BUNDLE_JOB_TOTAL, (Object)jobs.getTotal());
            json.put(JsonTags.BUNDLE_JOB_OFFSET, (Object)jobs.getStart());
            json.put(JsonTags.BUNDLE_JOB_LEN, (Object)jobs.getLen());
        } else {
            CoordinatorJobInfo jobs = null;
            CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
            if (action.equals("kill")) {
                try {
                    jobs = coordEngine.killJobs(filter, start, len);
                }
                catch (CoordinatorEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            if (action.equals("suspend")) {
                try {
                    jobs = coordEngine.suspendJobs(filter, start, len);
                }
                catch (CoordinatorEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            if (action.equals("resume")) {
                try {
                    jobs = coordEngine.resumeJobs(filter, start, len);
                }
                catch (CoordinatorEngineException ex) {
                    throw new XServletException(400, ex);
                }
            }
            json.put(JsonTags.COORDINATOR_JOBS, (Object)CoordinatorJobBean.toJSONArray(jobs.getCoordJobs(), timeZoneId));
            json.put(JsonTags.COORD_JOB_TOTAL, (Object)jobs.getTotal());
            json.put(JsonTags.COORD_JOB_OFFSET, (Object)jobs.getStart());
            json.put(JsonTags.COORD_JOB_LEN, (Object)jobs.getLen());
        }
        json.put((Object)"ids", (Object)V1JobsServlet.toJSONArray(ids));
        return json;
    }

    private static JSONArray toJSONArray(List<String> ids) {
        JSONArray array = new JSONArray();
        for (String id : ids) {
            array.add((Object)id);
        }
        return array;
    }
}

