/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.pentaho.plugin.jfreereport.reportcharts.XYChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.backport.XYDotRenderer;

public class ScatterPlotChartExpression
extends XYChartExpression {
    private static final long serialVersionUID = 7822813481960064738L;
    private int dotWidth = 5;
    private int dotHeight = 5;

    @Override
    protected JFreeChart computeXYChart(XYDataset xyDataset) {
        JFreeChart chart;
        if (xyDataset instanceof TimeSeriesCollection) {
            chart = ChartFactory.createTimeSeriesChart((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYDataset)xyDataset, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
            XYPlot xyPlot = chart.getXYPlot();
            XYLineAndShapeRenderer itemRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
            renderer.setBaseToolTipGenerator(itemRenderer.getBaseToolTipGenerator());
            renderer.setURLGenerator(itemRenderer.getURLGenerator());
            xyPlot.setRenderer((XYItemRenderer)renderer);
        } else {
            PlotOrientation orientation = this.computePlotOrientation();
            chart = ChartFactory.createScatterPlot((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYDataset)xyDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        }
        chart.getXYPlot().setRenderer((XYItemRenderer)new XYDotRenderer());
        this.configureLogarithmicAxis(chart.getXYPlot());
        return chart;
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
        XYPlot xypl = chart.getXYPlot();
        XYItemRenderer renderer = xypl.getRenderer();
        if (renderer instanceof XYDotRenderer) {
            XYDotRenderer renderer1 = (XYDotRenderer)renderer;
            renderer1.setDotHeight(this.getDotHeight());
            renderer1.setDotWidth(this.getDotWidth());
        }
    }

    public int getDotHeight() {
        return this.dotHeight;
    }

    public void setDotHeight(int height) {
        this.dotHeight = height;
    }

    public int getDotWidth() {
        return this.dotWidth;
    }

    public void setDotWidth(int width) {
        this.dotWidth = width;
    }
}

