/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.util.ArrayList;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.BandElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.SubreportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.model.Guideline;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.report.LinealModelReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.report.RowBandingDefinitionReadHandler;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BandTopLevelElementReadHandler
extends BandElementReadHandler {
    private Band rootLevelBand;
    private LinealModelReadHandler verticalLinealModel;
    private RowBandingDefinitionReadHandler rowBandingDefinitionReadHandler;
    private String bandType;
    private ArrayList subreports;

    public BandTopLevelElementReadHandler(Band rootLevelBand, String bandType) {
        super(rootLevelBand);
        this.rootLevelBand = rootLevelBand;
        this.bandType = bandType;
        this.subreports = new ArrayList();
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri)) {
            String type;
            if ("verticalLinealModel".equals(tagName)) {
                this.verticalLinealModel = new LinealModelReadHandler();
                return this.verticalLinealModel;
            }
            if ("ITEM_BAND".equals(this.bandType) && "rowBandingDefinition".equals(tagName)) {
                this.rowBandingDefinitionReadHandler = new RowBandingDefinitionReadHandler();
                return this.rowBandingDefinitionReadHandler;
            }
            if ("child".equalsIgnoreCase(tagName) && "org.pentaho.reportdesigner.crm.report.model.SubReportElement".equals(type = atts.getValue(uri, "type"))) {
                SubreportElementReadHandler readHandler = new SubreportElementReadHandler();
                this.subreports.add(readHandler);
                return readHandler;
            }
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    @Override
    protected void doneParsing() throws SAXException {
        Guideline[] guidelines;
        Expression expression;
        String visualHeight;
        float visualHeightParsed;
        String pageBreakAfter;
        String pageBreakBefore;
        String sticky;
        String repeat;
        String displayOnFirstPage;
        super.doneParsing();
        Properties result = this.getResult();
        String displayOnLastPage = result.getProperty("displayOnLastPage");
        if (displayOnLastPage != null) {
            if ("true".equals(displayOnLastPage)) {
                this.getStyle().setStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, (Object)Boolean.TRUE);
            } else {
                this.getStyle().setStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, (Object)Boolean.FALSE);
            }
        }
        if ((displayOnFirstPage = result.getProperty("displayOnFirstPage")) != null) {
            if ("true".equals(displayOnFirstPage)) {
                this.getStyle().setStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, (Object)Boolean.TRUE);
            } else {
                this.getStyle().setStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, (Object)Boolean.FALSE);
            }
        }
        if ((repeat = result.getProperty("repeat")) != null) {
            if ("true".equals(repeat)) {
                this.getStyle().setStyleProperty(BandStyleKeys.REPEAT_HEADER, (Object)Boolean.TRUE);
            } else {
                this.getStyle().setStyleProperty(BandStyleKeys.REPEAT_HEADER, (Object)Boolean.FALSE);
            }
        }
        if ((sticky = result.getProperty("sticky")) != null) {
            if ("true".equals(sticky)) {
                this.getStyle().setStyleProperty(BandStyleKeys.STICKY, (Object)Boolean.TRUE);
            } else {
                this.getStyle().setStyleProperty(BandStyleKeys.STICKY, (Object)Boolean.FALSE);
            }
        }
        if ((pageBreakBefore = result.getProperty("pageBreakBefore")) != null) {
            if ("true".equals(pageBreakBefore)) {
                this.getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, (Object)Boolean.TRUE);
            } else {
                this.getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, (Object)Boolean.FALSE);
            }
        }
        if ((pageBreakAfter = result.getProperty("pageBreakAfter")) != null) {
            if ("true".equals(pageBreakAfter)) {
                this.getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, (Object)Boolean.TRUE);
            } else {
                this.getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, (Object)Boolean.FALSE);
            }
        }
        if ((visualHeightParsed = ParserUtil.parseFloat((String)(visualHeight = result.getProperty("visualHeight")), (float)0.0f)) > 0.0f) {
            this.rootLevelBand.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "visual-height", (Object)new Double(visualHeightParsed));
        }
        AbstractReportDefinition report = (AbstractReportDefinition)this.getRootHandler().getHelperObject("::Report");
        if (this.rowBandingDefinitionReadHandler != null && (expression = (Expression)this.rowBandingDefinitionReadHandler.getObject()) != null) {
            report.addExpression(expression);
        }
        if (this.rootLevelBand instanceof AbstractRootLevelBand) {
            AbstractRootLevelBand arb = (AbstractRootLevelBand)this.rootLevelBand;
            for (int i = 0; i < this.subreports.size(); ++i) {
                SubreportElementReadHandler readHandler = (SubreportElementReadHandler)((Object)this.subreports.get(i));
                SubReport subReport = (SubReport)readHandler.getObject();
                arb.addSubReport(subReport);
            }
        }
        if (this.verticalLinealModel != null && (guidelines = this.verticalLinealModel.getGuidelineValues()) != null && guidelines.length > 0) {
            StringBuffer b = new StringBuffer(100);
            for (int i = 0; i < guidelines.length; ++i) {
                Guideline guideline = guidelines[i];
                if (i != 0) {
                    b.append(' ');
                }
                b.append(guideline.externalize());
            }
            this.rootLevelBand.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "VerticalGuideLines", (Object)b.toString());
        }
    }
}

