/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import java.text.MessageFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class FsCreateModes
extends FsPermission {
    private final FsPermission unmasked;

    public static FsPermission applyUMask(FsPermission mode, FsPermission umask) {
        if (mode.getUnmasked() != null) {
            return mode;
        }
        return FsCreateModes.create(mode.applyUMask(umask), mode);
    }

    public static FsCreateModes create(FsPermission masked, FsPermission unmasked) {
        assert (masked.getUnmasked() == null);
        assert (unmasked.getUnmasked() == null);
        return new FsCreateModes(masked, unmasked);
    }

    private FsCreateModes(FsPermission masked, FsPermission unmasked) {
        super(masked);
        this.unmasked = unmasked;
        assert (masked.getUnmasked() == null);
        assert (unmasked.getUnmasked() == null);
    }

    @Override
    public FsPermission getMasked() {
        return this;
    }

    @Override
    public FsPermission getUnmasked() {
        return this.unmasked;
    }

    @Override
    public String toString() {
        return MessageFormat.format("'{' masked: {0}, unmasked: {1} '}'", super.toString(), this.getUnmasked());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FsCreateModes that = (FsCreateModes)o;
        return this.getUnmasked().equals(that.getUnmasked());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getUnmasked().hashCode();
        return result;
    }
}

