/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.AbstractBeanToStringMatcher;
import com.google.code.beanmatchers.BeanOperations;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasToStringDescribingPropertiesExcludingMatcher<T>
extends AbstractBeanToStringMatcher<T> {
    private final List<String> excludedProperties;

    public HasToStringDescribingPropertiesExcludingMatcher(TypeBasedValueGenerator valueGenerator, String ... excludedProperties) {
        super(valueGenerator);
        this.excludedProperties = Arrays.asList(excludedProperties);
    }

    protected boolean matchesSafely(Class beanType, Description mismatchDescription) {
        List<String> properties = BeanOperations.properties(beanType);
        properties.removeAll(this.excludedProperties);
        return super.toStringDescribesProperties(beanType, properties, mismatchDescription);
    }

    public void describeTo(Description description) {
        if (this.excludedProperties.isEmpty()) {
            description.appendText("bean with toString() describing class name and all properties");
        } else {
            description.appendText("bean with toString() describing class name and all properties excluding ");
            description.appendValue(this.excludedProperties);
        }
    }
}

