/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.bundle.command.wikidoc.AnsiPrintingWikiVisitor;
import org.apache.karaf.bundle.command.wikidoc.WikiParser;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.Bundle;

@Command(scope="bundle", name="info", description="Displays detailed information of a given bundles.")
public class Info
extends BundlesCommand {
    public Info() {
        super(true);
    }

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        for (Bundle bundle : bundles) {
            this.printInfo(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printInfo(Bundle bundle) {
        String title = ShellUtil.getBundleName((Bundle)bundle);
        System.out.println("\n" + title);
        System.out.println(ShellUtil.getUnderlineString((String)title));
        URL bundleInfo = bundle.getEntry("OSGI-INF/bundle.info");
        if (bundleInfo != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(bundleInfo.openStream()));
                AnsiPrintingWikiVisitor visitor = new AnsiPrintingWikiVisitor(System.out);
                WikiParser parser = new WikiParser(visitor);
                parser.parse(reader);
            }
            catch (Exception e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

