/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumerProvider;

public class StepExternalResourceConsumerProvider
implements IStepExternalResourceConsumerProvider {
    private List<IStepExternalResourceConsumer> stepConsumers;
    private Map<Class<? extends BaseStepMeta>, Set<IStepExternalResourceConsumer>> stepConsumerMap = new ConcurrentHashMap<Class<? extends BaseStepMeta>, Set<IStepExternalResourceConsumer>>();

    public void setExternalResourceConsumers(List<IStepExternalResourceConsumer> stepConsumers) {
        this.stepConsumers = stepConsumers;
        this.loadStepExternalResourceConsumerMap();
    }

    public List<IStepExternalResourceConsumer> getExternalResourceConsumers() {
        return this.stepConsumers;
    }

    public List<IStepExternalResourceConsumer> getExternalResourceConsumers(Collection<Class<?>> types) {
        List<IStepExternalResourceConsumer> stepExternalResourceConsumers = this.getExternalResourceConsumers();
        if (types != null) {
            HashSet specificStepAnalyzers = new HashSet();
            for (Class<?> clazz : types) {
                if (!this.stepConsumerMap.containsKey(clazz)) continue;
                specificStepAnalyzers.addAll(this.stepConsumerMap.get(clazz));
            }
            stepExternalResourceConsumers = new ArrayList<IStepExternalResourceConsumer>(specificStepAnalyzers);
        }
        return stepExternalResourceConsumers;
    }

    public void addExternalResourceConsumer(IStepExternalResourceConsumer externalResourceConsumer) {
        Class metaClass;
        if (!this.stepConsumers.contains(externalResourceConsumer)) {
            this.stepConsumers.add(externalResourceConsumer);
        }
        if ((metaClass = externalResourceConsumer.getMetaClass()) != null) {
            Set<IStepExternalResourceConsumer> consumerSet = null;
            consumerSet = this.stepConsumerMap.containsKey(metaClass) ? this.stepConsumerMap.get(metaClass) : new HashSet<IStepExternalResourceConsumer>();
            consumerSet.add(externalResourceConsumer);
            this.stepConsumerMap.put(metaClass, consumerSet);
        }
    }

    public void removeExternalResourceConsumer(IStepExternalResourceConsumer externalResourceConsumer) {
        Class metaClass;
        if (this.stepConsumers.contains(externalResourceConsumer)) {
            try {
                this.stepConsumers.remove(externalResourceConsumer);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (externalResourceConsumer != null && (metaClass = externalResourceConsumer.getMetaClass()) != null) {
            Set<IStepExternalResourceConsumer> consumerSet = null;
            if (this.stepConsumerMap.containsKey(metaClass)) {
                consumerSet = this.stepConsumerMap.get(metaClass);
                consumerSet.remove(externalResourceConsumer);
                if (consumerSet.isEmpty()) {
                    this.stepConsumerMap.remove(metaClass);
                }
            }
        }
    }

    public Map<Class<? extends BaseStepMeta>, Set<IStepExternalResourceConsumer>> getStepConsumerMap() {
        return this.stepConsumerMap;
    }

    protected void loadStepExternalResourceConsumerMap() {
        this.stepConsumerMap = new HashMap<Class<? extends BaseStepMeta>, Set<IStepExternalResourceConsumer>>();
        if (this.stepConsumers != null) {
            for (IStepExternalResourceConsumer stepConsumer : this.stepConsumers) {
                this.addExternalResourceConsumer(stepConsumer);
            }
        }
    }
}

