/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.groupby;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;

public class GroupByStepAnalyzer
extends StepAnalyzer<GroupByMeta> {
    public Set<ComponentDerivationRecord> getChangeRecords(GroupByMeta groupByMeta) throws MetaverseAnalyzerException {
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        for (int i = 0; i < groupByMeta.getSubjectField().length; ++i) {
            ComponentDerivationRecord changeRecord = this.buildChangeRecord(groupByMeta.getSubjectField()[i], groupByMeta.getAggregateField()[i], groupByMeta.getAggregateType()[i]);
            changeRecords.add(changeRecord);
        }
        return changeRecords;
    }

    private ComponentDerivationRecord buildChangeRecord(String subjectField, String aggregateField, int aggregateType) {
        ComponentDerivationRecord changeRecord = new ComponentDerivationRecord(subjectField, aggregateField, ChangeType.DATA);
        changeRecord.addOperation(new Operation("aggregation", ChangeType.DATA, "transforms", subjectField + " using " + GroupByMeta.getTypeDesc((int)aggregateType) + " -> " + aggregateField));
        return changeRecord;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(GroupByMeta.class);
            }
        };
    }

    protected Set<StepField> getUsedFields(GroupByMeta meta) {
        String[] subjectFields;
        String[] groupFields;
        HashSet<StepField> usedFields = new HashSet<StepField>();
        for (String groupField : groupFields = meta.getGroupField()) {
            usedFields.addAll(this.createStepFields(groupField, this.getInputs()));
        }
        for (String subjectField : subjectFields = meta.getSubjectField()) {
            usedFields.addAll(this.createStepFields(subjectField, this.getInputs()));
        }
        return usedFields;
    }

    protected void customAnalyze(GroupByMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
    }
}

