/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import com.tinkerpop.blueprints.util.wrappers.event.listener.EdgePropertyChangedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.EdgePropertyRemovedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.VertexPropertyChangedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.VertexPropertyRemovedEvent;
import java.util.Set;

public abstract class EventElement
implements Element {
    protected final EventGraph eventGraph;
    protected final Element baseElement;

    protected EventElement(Element baseElement, EventGraph eventGraph) {
        this.baseElement = baseElement;
        this.eventGraph = eventGraph;
    }

    protected void onVertexPropertyChanged(Vertex vertex, String key, Object oldValue, Object newValue) {
        this.eventGraph.getTrigger().addEvent(new VertexPropertyChangedEvent(vertex, key, oldValue, newValue));
    }

    protected void onEdgePropertyChanged(Edge edge, String key, Object oldValue, Object newValue) {
        this.eventGraph.getTrigger().addEvent(new EdgePropertyChangedEvent(edge, key, oldValue, newValue));
    }

    protected void onVertexPropertyRemoved(Vertex vertex, String key, Object removedValue) {
        this.eventGraph.getTrigger().addEvent(new VertexPropertyRemovedEvent(vertex, key, removedValue));
    }

    protected void onEdgePropertyRemoved(Edge edge, String key, Object removedValue) {
        this.eventGraph.getTrigger().addEvent(new EdgePropertyRemovedEvent(edge, key, removedValue));
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.baseElement.getPropertyKeys();
    }

    @Override
    public Object getId() {
        return this.baseElement.getId();
    }

    @Override
    public <T> T removeProperty(String key) {
        Object propertyRemoved = this.baseElement.removeProperty(key);
        if (this instanceof Vertex) {
            this.onVertexPropertyRemoved((Vertex)((Object)this), key, propertyRemoved);
        } else if (this instanceof Edge) {
            this.onEdgePropertyRemoved((Edge)((Object)this), key, propertyRemoved);
        }
        return propertyRemoved;
    }

    @Override
    public <T> T getProperty(String key) {
        return this.baseElement.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        Object oldValue = this.baseElement.getProperty(key);
        this.baseElement.setProperty(key, value);
        if (this instanceof Vertex) {
            this.onVertexPropertyChanged((Vertex)((Object)this), key, oldValue, value);
        } else if (this instanceof Edge) {
            this.onEdgePropertyChanged((Edge)((Object)this), key, oldValue, value);
        }
    }

    public String toString() {
        return this.baseElement.toString();
    }

    public int hashCode() {
        return this.baseElement.hashCode();
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    public Element getBaseElement() {
        return this.baseElement;
    }

    @Override
    public void remove() {
        if (this instanceof Vertex) {
            this.eventGraph.removeVertex((Vertex)((Object)this));
        } else {
            this.eventGraph.removeEdge((Edge)((Object)this));
        }
    }
}

