/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DriverDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer.DataSourceProviderBundleWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer.DataSourceProviderWriteHandler;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class DriverDataSourceProviderWriteHandler
implements DataSourceProviderBundleWriteHandler,
DataSourceProviderWriteHandler {
    @Override
    public void write(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, DataSourceProvider dataSourceProvider) throws IOException, BundleWriterException {
        if (!(dataSourceProvider instanceof DriverDataSourceProvider)) {
            throw new BundleWriterException("This is not a Driver connection");
        }
        this.write(xmlWriter, (DriverDataSourceProvider)dataSourceProvider);
    }

    @Override
    public void write(ReportWriterContext reportWriter, XmlWriter xmlWriter, DataSourceProvider dataFactory) throws IOException, ReportWriterException {
        if (!(dataFactory instanceof DriverDataSourceProvider)) {
            throw new ReportWriterException("This is not a Driver connection");
        }
        this.write(xmlWriter, (DriverDataSourceProvider)dataFactory);
    }

    protected void write(XmlWriter writer, DriverDataSourceProvider provider) throws IOException {
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "driver", false);
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "driver", false);
        writer.writeTextNormalized(provider.getDriver(), false);
        writer.writeCloseTag();
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "url", false);
        writer.writeTextNormalized(provider.getUrl(), false);
        writer.writeCloseTag();
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "properties", false);
        String[] propertyNames = provider.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = propertyNames[i];
            String value = provider.getProperty(name);
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "property", "name", name, false);
            if (name.toLowerCase().contains("password")) {
                writer.writeTextNormalized(PasswordEncryptionService.getInstance().encrypt(value), false);
            } else {
                writer.writeTextNormalized(value, false);
            }
            writer.writeCloseTag();
        }
        writer.writeCloseTag();
        writer.writeCloseTag();
    }
}

