/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.protocol.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;

public class KerberosEncoder {
    public static ByteBuffer encode(AbstractAsn1Object asn1Obj, boolean isTcp) throws IOException {
        ByteBuffer response = null;
        ByteBuffer kerberosMessage = null;
        int responseLength = asn1Obj.computeLength();
        kerberosMessage = ByteBuffer.allocate(responseLength);
        try {
            asn1Obj.encode(kerberosMessage);
            if (isTcp) {
                response = ByteBuffer.allocate(responseLength + 4);
                response.putInt(responseLength);
                response.put(kerberosMessage.array());
            } else {
                response = kerberosMessage;
            }
            response.flip();
            return response;
        }
        catch (EncoderException e) {
            throw new IOException(e.getMessage());
        }
    }
}

