/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngine;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.Command;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.command.wf.CompletedActionCommand;
import org.apache.oozie.command.wf.CompletedActionXCommand;
import org.apache.oozie.command.wf.DefinitionCommand;
import org.apache.oozie.command.wf.DefinitionXCommand;
import org.apache.oozie.command.wf.ExternalIdCommand;
import org.apache.oozie.command.wf.ExternalIdXCommand;
import org.apache.oozie.command.wf.JobCommand;
import org.apache.oozie.command.wf.JobXCommand;
import org.apache.oozie.command.wf.JobsCommand;
import org.apache.oozie.command.wf.JobsXCommand;
import org.apache.oozie.command.wf.KillCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.command.wf.ReRunCommand;
import org.apache.oozie.command.wf.ReRunXCommand;
import org.apache.oozie.command.wf.ResumeCommand;
import org.apache.oozie.command.wf.ResumeXCommand;
import org.apache.oozie.command.wf.StartCommand;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SubmitCommand;
import org.apache.oozie.command.wf.SubmitMRCommand;
import org.apache.oozie.command.wf.SubmitMRXCommand;
import org.apache.oozie.command.wf.SubmitPigCommand;
import org.apache.oozie.command.wf.SubmitPigXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.command.wf.SuspendCommand;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.command.wf.WorkflowActionInfoCommand;
import org.apache.oozie.command.wf.WorkflowActionInfoXCommand;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogStreamer;

public class DagEngine
extends BaseEngine {
    private static final int HIGH_PRIORITY = 2;
    private boolean useXCommand = true;
    private static XLog LOG = XLog.getLog(DagEngine.class);
    private static final Set<String> FILTER_NAMES = new HashSet<String>();

    public DagEngine() {
        if (!Services.get().getConf().getBoolean("oozie.useXCommand", true)) {
            this.useXCommand = false;
            LOG.debug("Oozie DagEngine is not using XCommands.");
        } else {
            LOG.debug("Oozie DagEngine is using XCommands.");
        }
    }

    public DagEngine(String user, String authToken) {
        this();
        this.user = ParamChecker.notEmpty(user, "user");
        this.authToken = ParamChecker.notEmpty(authToken, "authToken");
    }

    @Override
    public String submitJob(Configuration conf, boolean startJob) throws DagEngineException {
        this.validateSubmitConfiguration(conf);
        try {
            String jobId;
            if (this.useXCommand) {
                SubmitXCommand submit = new SubmitXCommand(conf, this.getAuthToken());
                jobId = (String)submit.call();
            } else {
                SubmitCommand submit = new SubmitCommand(conf, this.getAuthToken());
                jobId = (String)submit.call();
            }
            if (startJob) {
                this.start(jobId);
            }
            return jobId;
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    public String submitHttpJob(Configuration conf, String jobType) throws DagEngineException {
        this.validateSubmitConfiguration(conf);
        try {
            String jobId;
            if (this.useXCommand) {
                XCommand submit = null;
                if (jobType.equals("pig")) {
                    submit = new SubmitPigXCommand(conf, this.getAuthToken());
                } else if (jobType.equals("mapreduce")) {
                    submit = new SubmitMRXCommand(conf, this.getAuthToken());
                }
                jobId = (String)submit.call();
            } else {
                Command submit = null;
                if (jobType.equals("pig")) {
                    submit = new SubmitPigCommand(conf, this.getAuthToken());
                } else if (jobType.equals("mapreduce")) {
                    submit = new SubmitMRCommand(conf, this.getAuthToken());
                }
                jobId = (String)submit.call();
            }
            this.start(jobId);
            return jobId;
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    private void validateSubmitConfiguration(Configuration conf) throws DagEngineException {
        if (conf.get("oozie.wf.application.path") == null) {
            throw new DagEngineException(ErrorCode.E0401, "oozie.wf.application.path");
        }
    }

    @Override
    public void start(String jobId) throws DagEngineException {
        try {
            if (this.useXCommand) {
                new StartXCommand(jobId).call();
            } else {
                new StartCommand(jobId).call();
            }
        }
        catch (CommandException e) {
            throw new DagEngineException(e);
        }
    }

    @Override
    public void resume(String jobId) throws DagEngineException {
        try {
            if (this.useXCommand) {
                new ResumeXCommand(jobId).call();
            } else {
                new ResumeCommand(jobId).call();
            }
        }
        catch (CommandException e) {
            throw new DagEngineException(e);
        }
    }

    @Override
    public void suspend(String jobId) throws DagEngineException {
        try {
            if (this.useXCommand) {
                new SuspendXCommand(jobId).call();
            } else {
                new SuspendCommand(jobId).call();
            }
        }
        catch (CommandException e) {
            throw new DagEngineException(e);
        }
    }

    @Override
    public void kill(String jobId) throws DagEngineException {
        try {
            if (this.useXCommand) {
                new KillXCommand(jobId).call();
            } else {
                new KillCommand(jobId).call();
            }
            LOG.info("User " + this.user + " killed the WF job " + jobId);
        }
        catch (CommandException e) {
            throw new DagEngineException(e);
        }
    }

    @Override
    public void change(String jobId, String changeValue) throws DagEngineException {
        throw new DagEngineException(ErrorCode.E1017, new Object[0]);
    }

    @Override
    public void reRun(String jobId, Configuration conf) throws DagEngineException {
        try {
            this.validateReRunConfiguration(conf);
            if (this.useXCommand) {
                new ReRunXCommand(jobId, conf, this.getAuthToken()).call();
            } else {
                new ReRunCommand(jobId, conf, this.getAuthToken()).call();
            }
            this.start(jobId);
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    private void validateReRunConfiguration(Configuration conf) throws DagEngineException {
        if (conf.get("oozie.wf.application.path") == null) {
            throw new DagEngineException(ErrorCode.E0401, "oozie.wf.application.path");
        }
        if (conf.get("oozie.wf.rerun.skip.nodes") == null && conf.get("oozie.wf.rerun.failnodes") == null) {
            throw new DagEngineException(ErrorCode.E0401, "oozie.wf.rerun.skip.nodes OR oozie.wf.rerun.failnodes");
        }
        if (conf.get("oozie.wf.rerun.skip.nodes") != null && conf.get("oozie.wf.rerun.failnodes") != null) {
            throw new DagEngineException(ErrorCode.E0404, "oozie.wf.rerun.skip.nodes OR oozie.wf.rerun.failnodes");
        }
    }

    public void processCallback(String actionId, String externalStatus, Properties actionData) throws DagEngineException {
        XLog.Info.get().clearParameter("GROUP");
        XLog.Info.get().clearParameter("USER");
        XCallable<Void> command = null;
        command = this.useXCommand ? new CompletedActionXCommand(actionId, externalStatus, actionData, 2) : new CompletedActionCommand(actionId, externalStatus, actionData, 2);
        if (!Services.get().get(CallableQueueService.class).queue(command)) {
            LOG.warn(4, "queue is full or system is in SAFEMODE, ignoring callback", new Object[0]);
        }
    }

    @Override
    public WorkflowJob getJob(String jobId) throws DagEngineException {
        try {
            if (this.useXCommand) {
                return (WorkflowJob)new JobXCommand(jobId).call();
            }
            return (WorkflowJob)new JobCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    @Override
    public WorkflowJob getJob(String jobId, int start, int length) throws DagEngineException {
        try {
            if (this.useXCommand) {
                return (WorkflowJob)new JobXCommand(jobId, start, length).call();
            }
            return (WorkflowJob)new JobCommand(jobId, start, length).call();
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    @Override
    public String getDefinition(String jobId) throws DagEngineException {
        try {
            if (this.useXCommand) {
                return (String)new DefinitionXCommand(jobId).call();
            }
            return (String)new DefinitionCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    @Override
    public void streamLog(String jobId, Writer writer) throws IOException, DagEngineException {
        XLogStreamer.Filter filter = new XLogStreamer.Filter();
        filter.setParameter("JOB", jobId);
        WorkflowJob job = this.getJob(jobId);
        Date lastTime = job.getEndTime();
        if (lastTime == null) {
            lastTime = job.getLastModifiedTime();
        }
        Services.get().get(XLogService.class).streamLog(filter, job.getCreatedTime(), lastTime, writer);
    }

    protected Map<String, List<String>> parseFilter(String filter) throws DagEngineException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    ArrayList<String> list;
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new DagEngineException(ErrorCode.E0420, filter, "elements must be name=value pairs");
                    }
                    if (!FILTER_NAMES.contains(pair[0])) {
                        throw new DagEngineException(ErrorCode.E0420, filter, XLog.format("invalid name [{0}]", pair[0]));
                    }
                    if (pair[0].equals("status")) {
                        try {
                            WorkflowJob.Status.valueOf((String)pair[1]);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new DagEngineException(ErrorCode.E0420, filter, XLog.format("invalid status [{0}]", pair[1]));
                        }
                    }
                    if ((list = (ArrayList<String>)map.get(pair[0])) == null) {
                        list = new ArrayList<String>();
                        map.put(pair[0], list);
                    }
                    list.add(pair[1]);
                    continue;
                }
                throw new DagEngineException(ErrorCode.E0420, filter, "elements must be name=value pairs");
            }
        }
        return map;
    }

    public WorkflowsInfo getJobs(String filterStr, int start, int len) throws DagEngineException {
        Map<String, List<String>> filter = this.parseFilter(filterStr);
        try {
            if (this.useXCommand) {
                return (WorkflowsInfo)new JobsXCommand(filter, start, len).call();
            }
            return (WorkflowsInfo)new JobsCommand(filter, start, len).call();
        }
        catch (CommandException dce) {
            throw new DagEngineException(dce);
        }
    }

    @Override
    public String getJobIdForExternalId(String externalId) throws DagEngineException {
        try {
            if (this.useXCommand) {
                return (String)new ExternalIdXCommand(externalId).call();
            }
            return (String)new ExternalIdCommand(externalId).call();
        }
        catch (CommandException dce) {
            throw new DagEngineException(dce);
        }
    }

    @Override
    public CoordinatorJob getCoordJob(String jobId) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, new Object[0]));
    }

    @Override
    public CoordinatorJob getCoordJob(String jobId, int start, int length) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, new Object[0]));
    }

    public WorkflowActionBean getWorkflowAction(String actionId) throws BaseEngineException {
        try {
            if (this.useXCommand) {
                return (WorkflowActionBean)new WorkflowActionInfoXCommand(actionId).call();
            }
            return (WorkflowActionBean)new WorkflowActionInfoCommand(actionId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public String dryrunSubmit(Configuration conf, boolean startJob) throws BaseEngineException {
        return null;
    }

    static {
        FILTER_NAMES.add("user");
        FILTER_NAMES.add("name");
        FILTER_NAMES.add("group");
        FILTER_NAMES.add("status");
        FILTER_NAMES.add("id");
    }
}

